/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSONValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ohos.BundleException;
import ohos.Compressor;
import ohos.FileUtils;
import ohos.HapVerifyInfo;
import ohos.Log;
import ohos.ModuleJsonUtil;
import ohos.PackageUtil;
import ohos.Utility;

public class CompressVerify {
    private static final String COMMA_SPLIT = ",";
    private static final String JSON_PROFILE = "config.json";
    private static final String MODULE_PROFILE = "module.json";
    private static final String PATCH_PROFILE = "patch.json";
    private static final String PKG_CONTEXT_INFO = "pkgContextInfo.json";
    private static final String PROFILE_NAME = "CAPABILITY.profile";
    private static final String INDEX_PROFILE = "resources.index";
    private static final String RPCID_PROFILE = "rpcid.sc";
    private static final String PACK_INFO = "pack.info";
    private static final String PACK_RES = "pack.res";
    private static final String HAP_SUFFIX = ".hap";
    private static final String HAR_SUFFIX = ".har";
    private static final String APP_SUFFIX = ".app";
    private static final String APK_SUFFIX = ".apk";
    private static final String DEX_SUFFIX = ".dex";
    private static final String ABC_SUFFIX = ".abc";
    private static final String SO_SUFFIX = ".so";
    private static final String JAR_SUFFIX = ".jar";
    private static final String TXT_SUFFIX = ".txt";
    private static final String PNG_SUFFIX = ".png";
    private static final String RES_SUFFIX = ".res";
    private static final String HQF_SUFFIX = ".hqf";
    private static final String APPQF_SUFFIX = ".appqf";
    private static final String HSP_SUFFIX = ".hsp";
    private static final String JSON_SUFFIX = ".json";
    private static final String FALSE = "false";
    private static final String ENTRY_CARD_DIRECTORY_NAME = "EntryCard";
    private static final String VERSION_NAME_PATTERN = "^[0-9.]+|(?=.*[{])(?=.*[}])[0-9a-zA-Z_.{}]+$";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String BUNDLE_TYPE_SHARE = "shared";
    private static final String BUNDLE_TYPE_APP = "app";
    private static final String BUNDLE_TYPE_APP_SERVICE = "appService";
    private static final String SKILLS_ENTITIES = "entities";
    private static final String SKILLS_ACTIONS = "actions";
    private static final String ACTION_SYSTEM_HOME = "action.system.home";
    private static final String ENTITY_SYSTEM_HOME = "entity.system.home";
    private static final String BUNDLE_NAME_PATTERN = "([a-zA-Z]|[a-zA-Z]+(_*[0-9a-zA-Z])+)(\\.[0-9a-zA-Z]|\\.[0-9a-zA-Z]+(_*[0-9a-zA-Z])+){2,}";
    private static final int BUNDLE_NAME_LEN_MIN = 7;
    private static final int BUNDLE_NAME_LEN_MAX = 128;
    private static final Log LOG = new Log(CompressVerify.class.toString());
    private static final boolean TYPE_FILE = true;
    private static final boolean TYPE_DIR = false;
    private static final Integer ONE = 1;

    public static boolean commandVerify(Utility utility) {
        if (utility == null) {
            LOG.error("CompressVerify::commandVerify utility is null.");
            return false;
        }
        if (!(utility.getForceRewrite().isEmpty() || "true".equals(utility.getForceRewrite()) || FALSE.equals(utility.getForceRewrite()))) {
            LOG.error("CompressVerify::commandVerify forceRewrite is invalid.");
            return false;
        }
        return CompressVerify.commandPathVerify(utility);
    }

    private static boolean commandPathVerify(Utility utility) {
        switch (utility.getMode()) {
            case "hap": {
                if (!utility.getBinPath().isEmpty() && utility.getJsonPath().isEmpty()) {
                    return CompressVerify.isOutPathValid(utility, HAP_SUFFIX);
                }
                return CompressVerify.isVerifyValidInHapCommonMode(utility) && CompressVerify.isVerifyValidInHapMode(utility);
            }
            case "har": {
                return CompressVerify.isVerifyValidInHarMode(utility);
            }
            case "app": {
                return CompressVerify.isVerifyValidInAppMode(utility);
            }
            case "fastApp": {
                return PackageUtil.isVerifyValidInFastAppMode(utility);
            }
            case "res": {
                return CompressVerify.isVerifyValidInResMode(utility);
            }
            case "multiApp": {
                return CompressVerify.isVerifyValidInMultiAppMode(utility);
            }
            case "hqf": {
                return CompressVerify.isVerifyValidInHQFMode(utility);
            }
            case "appqf": {
                return CompressVerify.isVerifyValidInAPPQFMode(utility);
            }
            case "hsp": {
                return CompressVerify.isVerifyValidInHspMode(utility);
            }
            case "hapAddition": {
                return CompressVerify.isVerifyValidInHapAdditionMode(utility);
            }
            case "versionNormalize": {
                return CompressVerify.validateVersionNormalizeMode(utility);
            }
            case "packageNormalize": {
                return CompressVerify.validatePackageNormalizeMode(utility);
            }
        }
        LOG.error("CompressVerify::commandVerify mode is invalid.");
        return false;
    }

    private static boolean isBundleNameValid(String string) {
        if (string != null && string.length() >= 7 && string.length() <= 128) {
            Pattern pattern = Pattern.compile(BUNDLE_NAME_PATTERN);
            return pattern.matcher(string).matches();
        }
        return false;
    }

    private static boolean validatePackageNormalizeMode(Utility utility) {
        if (utility.getHspList().isEmpty()) {
            LOG.error("CompressVerify::validatePackageNormalizeMode hsp-list is empty.");
            return false;
        }
        if (!CompressVerify.compatibleProcess(utility, utility.getHspList(), utility.getFormattedHspPathList(), HSP_SUFFIX)) {
            LOG.error("CompressVerify::validatePackageNormalizeMode hsp-list is invalid.");
            return false;
        }
        if (!CompressVerify.isBundleNameValid(utility.getBundleName())) {
            LOG.error("CompressVerify::validatePackageNormalizeMode bundle-name is invalid.");
            return false;
        }
        if (utility.getVersionCode() <= 0) {
            LOG.error("CompressVerify::validatePackageNormalizeMode version-code is invalid.");
            return false;
        }
        if (utility.getOutPath().isEmpty()) {
            LOG.error("CompressVerify::validatePackageNormalizeMode out-path is empty.");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (!file.isDirectory()) {
            LOG.error("CompressVerify::validatePackageNormalizeMode out-path is not a directory.");
            return false;
        }
        return true;
    }

    private static boolean validateVersionNormalizeMode(Utility utility) {
        if (utility.getInputList().isEmpty()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode input-list is empty.");
            return false;
        }
        if (!CompressVerify.handleHapAndHspInput(utility, utility.getInputList(), utility.getFormattedHapList())) {
            LOG.error("CompressVerify::validateVersionNormalizeMode input-list is invalid.");
            return false;
        }
        if (utility.getFormattedHapList().isEmpty()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode input-list is empty.");
            return false;
        }
        if (utility.getVersionCode() <= 0) {
            LOG.error("CompressVerify::validateVersionNormalizeMode version-code is invalid.");
            return false;
        }
        if (utility.getVersionName().isEmpty()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode version-name is empty.");
            return false;
        }
        Pattern pattern = Pattern.compile(VERSION_NAME_PATTERN);
        Matcher matcher = pattern.matcher(utility.getVersionName());
        if (!matcher.matches()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode version-name is not valid.");
            return false;
        }
        if (utility.getOutPath().isEmpty()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode out-path is empty.");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (!file.isDirectory()) {
            LOG.error("CompressVerify::validateVersionNormalizeMode out-path is not a directory.");
            return false;
        }
        return true;
    }

    private static boolean isValidRpcid(Utility utility) {
        if (!utility.getRpcidPath().isEmpty()) {
            File file = new File(utility.getRpcidPath());
            if (!file.isFile()) {
                LOG.error("CompressVerify::isArgsValidInHapMode rpcid-path is not a file.");
                return false;
            }
            if (!RPCID_PROFILE.equals(file.getName())) {
                LOG.error("CompressVerify::isArgsValidInHapMode rpcid-path must be rpcid.sc file.");
                return false;
            }
        }
        return true;
    }

    private static boolean isValidPackInfo(Utility utility) {
        if (!utility.getPackInfoPath().isEmpty()) {
            File file = new File(utility.getPackInfoPath());
            if (!file.isFile()) {
                LOG.error("CompressVerify::isArgsValidInHapMode --pack-info-path is not a file.");
                return false;
            }
            if (!PACK_INFO.equals(file.getName())) {
                LOG.error("CompressVerify::isArgsValidInHapMode --pack-info-path must be pack.info file.");
                return false;
            }
        }
        return true;
    }

    private static boolean isVerifyValidInHapCommonMode(Utility utility) {
        File file;
        if (utility.getJsonPath().isEmpty()) {
            LOG.error("CompressVerify::commandPathVerify json-path is empty.");
            return false;
        }
        if (!CompressVerify.isPathValid(utility.getJsonPath(), true, JSON_PROFILE) && !CompressVerify.isPathValid(utility.getJsonPath(), true, MODULE_PROFILE)) {
            LOG.error("CompressVerify::isArgsValidInHarMode json-path must be config.json file.");
            return false;
        }
        if (!CompressVerify.isValidRpcid(utility) || !CompressVerify.isValidPackInfo(utility)) {
            return false;
        }
        if (!utility.getApkPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getApkPath(), utility.getFormattedApkPathList(), APK_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode shell-apk-path is invalid.");
            return false;
        }
        if (!(utility.getProfilePath().isEmpty() || (file = new File(utility.getProfilePath())).isFile() && PROFILE_NAME.equals(file.getName()))) {
            LOG.error("CompressVerify::isArgsValidInHapMode profile-path must be CAPABILITY.profile file.");
            return false;
        }
        if (!utility.getDexPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getDexPath(), utility.getFormattedDexPathList(), DEX_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode dex-path is invalid.");
            return false;
        }
        if (!utility.getAbcPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getAbcPath(), utility.getFormattedAbcPathList(), ABC_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode abc-path is invalid.");
            return false;
        }
        if (!utility.getDirList().isEmpty() && !CompressVerify.splitDirList(utility, utility.getDirList(), utility.getFormatedDirList())) {
            LOG.error("CompressVerify::isArgsValidInHapMode --dir-list is invalid.");
            return false;
        }
        if (!(utility.getPkgContextPath().isEmpty() || (file = new File(utility.getPkgContextPath())).isFile() && PKG_CONTEXT_INFO.equals(file.getName()))) {
            LOG.error("CompressVerify::isArgsValidInHapMode --pkg-context-path file must be pkgContextInfo.json");
            return false;
        }
        return true;
    }

    private static boolean isVerifyValidInHapMode(Utility utility) {
        File file = new File(utility.getIndexPath());
        if (!utility.getIndexPath().isEmpty() && !file.isFile() && INDEX_PROFILE.equals(file.getName())) {
            LOG.error("CompressVerify::isArgsValidInHapMode index-path must be resources.index file.");
            return false;
        }
        if (!utility.getSoPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getSoPath(), utility.getFormattedSoPathList(), SO_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode maple-so-path is invalid.");
            return false;
        }
        if (!utility.getAbilitySoPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getAbilitySoPath(), utility.getFormattedAbilitySoPathList(), SO_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode ability-so-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getSoDir())) {
            LOG.error("CompressVerify::isArgsValidInHapMode maple-so-dir is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getLibPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode lib-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getHnpPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode hnp-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getResPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode res-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getResourcesPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode resources-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getAssetsPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode assets-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getSharedLibsPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode shared-libs-path is invalid.");
            return false;
        }
        if (!utility.getJarPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getJarPath(), utility.getFormattedJarPathList(), JAR_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode jar-path is invalid.");
            return false;
        }
        if (!utility.getTxtPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getTxtPath(), utility.getFormattedTxtPathList(), TXT_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode txt-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getANPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode an-path is invalid.");
            return false;
        }
        if (!utility.getEtsPath().isEmpty() && !CompressVerify.isPathExists(utility.getEtsPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode ets-path is invalid.");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, HAP_SUFFIX);
    }

    private static boolean isHapPathValid(String string) {
        return !string.isEmpty() && !CompressVerify.isPathValid(string, false, null);
    }

    private static boolean isVerifyValidInHarMode(Utility utility) {
        if (utility.getJsonPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInHarMode json-path is empty.");
            return false;
        }
        if (!CompressVerify.isPathValid(utility.getJsonPath(), true, JSON_PROFILE) && !CompressVerify.isPathValid(utility.getJsonPath(), true, MODULE_PROFILE)) {
            LOG.error("CompressVerify::isArgsValidInHarMode json-path must be config.json file.");
            return false;
        }
        if (!utility.getJarPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getJarPath(), utility.getFormattedJarPathList(), JAR_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHarMode jar-path is invalid.");
            return false;
        }
        if (!utility.getTxtPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getTxtPath(), utility.getFormattedTxtPathList(), TXT_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHarMode txt-path is invalid.");
            return false;
        }
        if (!utility.getLibPath().isEmpty() && !CompressVerify.isPathValid(utility.getLibPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode lib-path is invalid.");
            return false;
        }
        if (!utility.getResPath().isEmpty() && !CompressVerify.isPathValid(utility.getResPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode res-path is invalid.");
            return false;
        }
        if (utility.getResourcesPath().isEmpty() || !CompressVerify.isPathValid(utility.getResourcesPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode resources-path is invalid.");
            return false;
        }
        if (!utility.getAssetsPath().isEmpty() && !CompressVerify.isPathValid(utility.getAssetsPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode assets-path is invalid.");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, HAR_SUFFIX);
    }

    private static boolean isVerifyValidInAppMode(Utility utility) {
        if (!CompressVerify.checkBundleTypeConsistency(utility)) {
            LOG.error("CompressVerify::isArgsValidInAppMode bundleType is inconsistent");
            return false;
        }
        if (!CompressVerify.checkInputModulePath(utility)) {
            LOG.warning("CompressVerify::isArgsValidInAppMode input hap-path or hspPath is invalid.");
        }
        if (!utility.getHapPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getHapPath(), utility.getFormattedHapPathList(), HAP_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInAppMode hap-path is invalid.");
            return false;
        }
        if (!utility.getHspPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getHspPath(), utility.getFormattedHspPathList(), HSP_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInAppMode hsp-path is invalid.");
            return false;
        }
        if (utility.getPackInfoPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-info-path is empty.");
            return false;
        }
        File file = new File(utility.getPackInfoPath());
        if (!file.isFile() || !PACK_INFO.equals(file.getName())) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-info-path is invalid.");
            return false;
        }
        if (!CompressVerify.isValidEncryptJsonFile(utility)) {
            LOG.error("CompressVerify::isVerifyValidInAppMode encrypt-path is invalid.");
            return false;
        }
        if (!utility.getSignaturePath().isEmpty() && !new File(utility.getSignaturePath()).isFile()) {
            LOG.error("CompressVerify::isArgsValidInAppMode signature-path is invalid.");
            return false;
        }
        if (!utility.getCertificatePath().isEmpty() && !new File(utility.getCertificatePath()).isFile()) {
            LOG.error("CompressVerify::isArgsValidInAppMode certificate-path is invalid.");
            return false;
        }
        if (!utility.getEntryCardPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getEntryCardPath(), utility.getformattedEntryCardPathList(), PNG_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInAppMode entrycard-path is invalid.");
            return false;
        }
        if (!utility.getPackResPath().isEmpty() && !CompressVerify.isPathValid(utility.getPackResPath(), true, PACK_RES)) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-res-path is invalid.");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, APP_SUFFIX);
    }

    private static boolean checkBundleTypeConsistency(Utility utility) {
        String string = new String();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        CompressVerify.compatibleProcess(utility, utility.getHapPath(), arrayList, HAP_SUFFIX);
        CompressVerify.compatibleProcess(utility, utility.getHspPath(), arrayList2, HSP_SUFFIX);
        try {
            HapVerifyInfo hapVerifyInfo;
            Iterator iterator;
            if (!arrayList.isEmpty()) {
                iterator = Compressor.parseStageHapVerifyInfo((String)arrayList.get(0));
                string = ((HapVerifyInfo)((Object)iterator)).getBundleType();
            } else {
                iterator = Compressor.parseStageHapVerifyInfo((String)arrayList2.get(0));
                string = ((HapVerifyInfo)((Object)iterator)).getBundleType();
            }
            for (String string2 : arrayList) {
                hapVerifyInfo = Compressor.parseStageHapVerifyInfo(string2);
                if (string.equals(hapVerifyInfo.getBundleType())) continue;
                LOG.error("bundleType is not same");
                return false;
            }
            for (String string2 : arrayList2) {
                hapVerifyInfo = Compressor.parseStageHapVerifyInfo(string2);
                if (string.equals(hapVerifyInfo.getBundleType())) continue;
                LOG.error("bundleType is not same");
                return false;
            }
        }
        catch (BundleException bundleException) {
            return true;
        }
        return true;
    }

    private static boolean checkInputModulePath(Utility utility) {
        boolean bl = CompressVerify.isSharedApp(utility);
        boolean bl2 = CompressVerify.isAppService(utility);
        if (utility.getHapPath().isEmpty() && !bl && !bl2) {
            LOG.warning("CompressVerify::CheckInputModulePath hap-path is empty.");
            return false;
        }
        if (utility.getHspPath().isEmpty() && bl2) {
            LOG.warning("CompressVerify::CheckInputModulePath hsp-path is empty.");
            return false;
        }
        return true;
    }

    private static boolean isVerifyValidInMultiAppMode(Utility utility) {
        if (utility.getAppList().isEmpty() && utility.getHapList().isEmpty() && utility.getHspList().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode input app-list, hap-list and hsp-list are null.");
            return false;
        }
        if (!utility.getAppList().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getAppList(), utility.getFormattedAppList(), APP_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode app-list is invalid.");
            return false;
        }
        if (!utility.getHapList().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getHapList(), utility.getFormattedHapList(), HAP_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode hap-list is invalid.");
            return false;
        }
        if (!utility.getHspList().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getHspList(), utility.getFormattedHapList(), HSP_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode hsp-list is invalid.");
            return false;
        }
        if (!CompressVerify.isValidEncryptJsonFile(utility)) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode encrypt-path is invalid.");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file.exists()) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode out file already existed.");
            return false;
        }
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(APP_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInMultiAppMode out-path must end with .app.");
            return false;
        }
        return true;
    }

    private static boolean isVerifyValidInResMode(Utility utility) {
        if (!CompressVerify.isPathValid(utility.getPackInfoPath(), true, PACK_INFO)) {
            LOG.error("CompressVerify::isArgsValidInResMode pack-info-path is invalid.");
            return false;
        }
        if (!CompressVerify.isDirectoryValidStrictCase(utility.getEntryCardPath(), ENTRY_CARD_DIRECTORY_NAME)) {
            LOG.error("CompressVerify::isArgsValidInResMode the level-1 directory name must is EntryCard, current is " + utility.getEntryCardPath());
            return false;
        }
        if (!CompressVerify.compatibleProcess(utility, utility.getEntryCardPath(), utility.getformattedEntryCardPathList(), PNG_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInResMode entrycard-path is invalid.");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, RES_SUFFIX);
    }

    private static boolean isVerifyValidInHQFMode(Utility utility) {
        if (utility.getJsonPath().isEmpty()) {
            LOG.error("must input patch.json file when pack hqf file.");
            return false;
        }
        if (!utility.getEtsPath().isEmpty() && !CompressVerify.isPathValid(utility.getEtsPath(), false, null)) {
            LOG.error("must input valid ets path when pack hqf file.");
            return false;
        }
        if (!CompressVerify.isPathValid(utility.getJsonPath(), true, PATCH_PROFILE)) {
            LOG.error("input patch.json is invalid when pack hqf file.");
            return false;
        }
        if (!utility.getLibPath().isEmpty() && !CompressVerify.isPathValid(utility.getLibPath(), false, null)) {
            LOG.error("input lib path is invalid when pack hqf file.");
            return false;
        }
        if (!utility.getResourcesPath().isEmpty() && !CompressVerify.isPathValid(utility.getResourcesPath(), false, null)) {
            LOG.error("input resources path is invalid when pack hqf file.");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file.exists()) {
            LOG.error(file.getName() + " already exist.");
            return false;
        }
        if (!utility.getOutPath().endsWith(HQF_SUFFIX)) {
            LOG.error("input out file must end with .hqf.");
            return false;
        }
        return true;
    }

    private static boolean isVerifyValidInAPPQFMode(Utility utility) {
        if (utility.getHqfList().isEmpty()) {
            LOG.error("input hqf list is empty.");
            return false;
        }
        if (!CompressVerify.compatibleProcess(utility, utility.getHqfList(), utility.getFormatedHQFList(), HQF_SUFFIX)) {
            LOG.error("input hqf list is invalid.");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file.exists()) {
            LOG.error("Error out file already existed.");
            return false;
        }
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(APPQF_SUFFIX)) {
            LOG.error("Error out-path must end with .app.");
            return false;
        }
        return true;
    }

    public static boolean compatibleProcess(Utility utility, String string, List<String> list, String string2) {
        if (CompressVerify.isPathValid(string, false, null)) {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (File file2 : fileArray) {
                if (!file2.getName().toLowerCase(Locale.ENGLISH).endsWith(string2)) continue;
                list.add(file2.toString());
            }
            return true;
        }
        String string3 = "";
        List<String> list2 = CompressVerify.removeDuplicatePath(string);
        for (String string4 : list2) {
            string3 = utility.getFormattedPath(string4);
            if (!CompressVerify.isPathValid(string3, true, string2)) {
                return false;
            }
            list.add(string3);
        }
        return true;
    }

    private static boolean handleHapAndHspInput(Utility utility, String string, List<String> list) {
        if (CompressVerify.isPathValid(string, false, null)) {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (File file2 : fileArray) {
                if (!file2.getName().toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX) && !file2.getName().toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) continue;
                list.add(file2.toString());
            }
            return true;
        }
        String string2 = "";
        List<String> list2 = CompressVerify.removeDuplicatePath(string);
        for (String string3 : list2) {
            string2 = utility.getFormattedPath(string3);
            if (!CompressVerify.isPathValid(string2, true, HSP_SUFFIX) && !CompressVerify.isPathValid(string2, true, HAP_SUFFIX)) {
                LOG.error("input file " + string2 + " not valid");
                return false;
            }
            list.add(string2);
        }
        return true;
    }

    private static boolean splitDirList(Utility utility, String string, List<String> list) {
        List<String> list2 = CompressVerify.removeDuplicatePath(string);
        for (String string2 : list2) {
            String string3 = utility.getFormattedPath(string2);
            if (!CompressVerify.isPathValid(string3, false, null)) {
                return false;
            }
            list.add(string3);
        }
        return true;
    }

    private static boolean isOutPathValid(Utility utility, String string) {
        File file = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file.exists()) {
            LOG.error("CompressVerify::isOutPathValid out file already existed.");
            return false;
        }
        if (HAP_SUFFIX.equals(string)) {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .hap.");
                return false;
            }
            return true;
        }
        if (HAR_SUFFIX.equals(string)) {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(HAR_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .har.");
                return false;
            }
            return true;
        }
        if (APP_SUFFIX.equals(string)) {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(APP_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .app.");
                return false;
            }
            return true;
        }
        if (RES_SUFFIX.equals(string)) {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(RES_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .res.");
                return false;
            }
            return true;
        }
        if (HSP_SUFFIX.equals(string)) {
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .hsp.");
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isPathValid(String string, boolean bl, String string2) {
        File file = new File(string);
        if (bl && file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(string2)) {
            return true;
        }
        return !bl && file.isDirectory();
    }

    private static boolean isPathExists(String string) {
        if (string != null && !string.isEmpty()) {
            File file = new File(string);
            return file.exists();
        }
        return false;
    }

    private static boolean isDirectoryValidStrictCase(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            LOG.error("CompressVerify::isDirectoryValidStrictCase directory is not exist, directoryPath: " + string + ".");
            return false;
        }
        if (file.isDirectory()) {
            return string2.equals(file.getName());
        }
        return false;
    }

    private static List<String> removeDuplicatePath(String string) {
        String[] stringArray = string.split(COMMA_SPLIT);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static boolean isVerifyValidInHspMode(Utility utility) {
        File file;
        if (utility.getJsonPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInHspMode json-path is empty.");
            return false;
        }
        if (!CompressVerify.isPathValid(utility.getJsonPath(), true, MODULE_PROFILE)) {
            LOG.error("CompressVerify::isArgsValidInHspMode json-path must be module.json file.");
            return false;
        }
        if (CompressVerify.isBundleTypeShared(utility) || CompressVerify.isBundleTypeAppService(utility)) {
            boolean bl = CompressVerify.hspHasAbilities(utility);
            boolean bl2 = CompressVerify.hspHasExtensionAbilities(utility);
            if (bl && bl2) {
                LOG.error("shared/appService hsp has abilities and extensionAbilities");
                return false;
            }
            if (bl) {
                LOG.error("shared/appService hsp has abilities");
                return false;
            }
            if (bl2) {
                LOG.error("shared/appService hsp has extensionAbilities");
                return false;
            }
        }
        if (CompressVerify.hasHomeAbility(utility)) {
            LOG.error("hsp has entry ability");
            return false;
        }
        if (CompressVerify.hasHomeExtensionAbility(utility)) {
            LOG.error("hsp has entry extensionAbility");
            return false;
        }
        if (!utility.getJarPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getJarPath(), utility.getFormattedJarPathList(), JAR_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHspMode jar-path is invalid.");
            return false;
        }
        if (!utility.getTxtPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getTxtPath(), utility.getFormattedTxtPathList(), TXT_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHspMode txt-path is invalid.");
            return false;
        }
        if (!utility.getLibPath().isEmpty() && !CompressVerify.isPathValid(utility.getLibPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHspMode lib-path is invalid.");
            return false;
        }
        if (!utility.getResPath().isEmpty() && !CompressVerify.isPathValid(utility.getResPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHspMode res-path is invalid.");
            return false;
        }
        if (!utility.getResourcesPath().isEmpty() && !CompressVerify.isPathValid(utility.getResourcesPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHspMode resources-path is invalid.");
            return false;
        }
        if (!utility.getAssetsPath().isEmpty() && !CompressVerify.isPathValid(utility.getAssetsPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHspMode assets-path is invalid.");
            return false;
        }
        if (!utility.getDirList().isEmpty() && !CompressVerify.splitDirList(utility, utility.getDirList(), utility.getFormatedDirList())) {
            LOG.error("CompressVerify::isArgsValidInHapMode --dir-list is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getAPPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode ap-path is invalid.");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getANPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode an-path is invalid.");
            return false;
        }
        if (!(utility.getPkgContextPath().isEmpty() || (file = new File(utility.getPkgContextPath())).isFile() && PKG_CONTEXT_INFO.equals(file.getName()))) {
            LOG.error("CompressVerify::isArgsValidInHspMode --pkg-context-path file must be pkgContextInfo.json");
            return false;
        }
        if (!utility.getEtsPath().isEmpty() && !CompressVerify.isPathExists(utility.getEtsPath())) {
            LOG.error("CompressVerify::isArgsValidInHspMode ets-path is invalid.");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, HSP_SUFFIX);
    }

    private static boolean isVerifyValidInHapAdditionMode(Utility utility) {
        if (utility.getHapPath().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode hapPath is empty.");
            return false;
        }
        String string = utility.getAbsoluteHapPath();
        File file = new File(string);
        if (file.isDirectory()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode hapPath cannot be a folder.");
            return false;
        }
        if (!string.endsWith(HAP_SUFFIX) && !string.endsWith(HSP_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode hapPath is invalid.");
            return false;
        }
        if (!file.exists()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode hap file does not exist.");
            return false;
        }
        if (utility.getJsonPath().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode jsonPath is empty.");
            return false;
        }
        if (!utility.getJsonPath().endsWith(JSON_SUFFIX)) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode jsonPath is invalid.");
            return false;
        }
        File file2 = new File(utility.getJsonPath());
        if (!file2.exists()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode json file does not exist.");
            return false;
        }
        if (!CompressVerify.checkJsonIsValid(file2)) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode json format is incorrect.");
            return false;
        }
        if (utility.getOutPath().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode outPath is empty.");
            return false;
        }
        File file3 = new File(utility.getOutPath());
        if (file3.exists() && file3.isFile()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode outPath is file.");
            return false;
        }
        File file4 = new File(utility.getAbsoluteHapPath());
        String string2 = file4.getName();
        String string3 = utility.getOutPath() + LINUX_FILE_SEPARATOR + string2;
        File file5 = new File(string3);
        if (FALSE.equals(utility.getForceRewrite()) && file5.exists()) {
            LOG.error("CompressVerify::isVerifyValidInHapAdditionMode target file already exists.");
            return false;
        }
        return true;
    }

    private static boolean checkJsonIsValid(File file) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = new FileReader(file);
            Throwable throwable = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                int n = 0;
                while ((n = ((Reader)inputStreamReader).read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStreamReader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOG.error("CompressVerify::CheckJsonIsValid failed: " + iOException.getMessage());
            return false;
        }
        object = JSONValidator.from(stringBuffer.toString());
        return ((JSONValidator)object).validate();
    }

    private static boolean isSharedApp(Utility utility) {
        if (!utility.getHapPath().isEmpty()) {
            return false;
        }
        if (utility.getHspPath().isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (CompressVerify.compatibleProcess(utility, utility.getHspPath(), arrayList, HSP_SUFFIX) && CompressVerify.verifyIsSharedApp(arrayList)) {
            utility.setIsSharedApp(true);
            return true;
        }
        return false;
    }

    private static boolean isAppService(Utility utility) {
        ArrayList<String> arrayList;
        if (!utility.getHapPath().isEmpty()) {
            arrayList = new ArrayList<String>();
            if (CompressVerify.compatibleProcess(utility, utility.getHapPath(), arrayList, HSP_SUFFIX) && CompressVerify.verifyIsAppService(arrayList)) {
                utility.setIsAppService(true);
                return true;
            }
        }
        if (utility.getHspPath().isEmpty()) {
            return false;
        }
        arrayList = new ArrayList();
        if (CompressVerify.compatibleProcess(utility, utility.getHspPath(), arrayList, HSP_SUFFIX) && CompressVerify.verifyIsAppService(arrayList)) {
            utility.setIsAppService(true);
            return true;
        }
        return false;
    }

    private static boolean verifyIsAppService(List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        try {
            for (String string : list) {
                HapVerifyInfo hapVerifyInfo = Compressor.parseStageHapVerifyInfo(string);
                if (hapVerifyInfo.getBundleType().equals(BUNDLE_TYPE_APP_SERVICE)) continue;
                return false;
            }
        }
        catch (BundleException bundleException) {
            return false;
        }
        return true;
    }

    private static boolean verifyIsSharedApp(List<String> list) {
        try {
            HapVerifyInfo hapVerifyInfo = Compressor.parseStageHapVerifyInfo(list.get(0));
            return hapVerifyInfo.getBundleType().equals(BUNDLE_TYPE_SHARE);
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private static boolean isBundleTypeShared(Utility utility) {
        try {
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (optional.isPresent()) {
                return ModuleJsonUtil.parseStageBundleType(optional.get()).equals(BUNDLE_TYPE_SHARE);
            }
            LOG.error("CompressVerify::isBundleTypeShared jsonPath content invalid");
            return false;
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::isBundleTypeShared exception: " + bundleException.getMessage());
            return false;
        }
    }

    private static boolean isBundleTypeAppService(Utility utility) {
        try {
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (optional.isPresent()) {
                return ModuleJsonUtil.parseStageBundleType(optional.get()).equals(BUNDLE_TYPE_APP_SERVICE);
            }
            LOG.error("CompressVerify::isBundleTypeAppService jsonPath content invalid");
            return false;
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::isBundleTypeAppService exception: " + bundleException.getMessage());
            return false;
        }
    }

    private static boolean hspHasAbilities(Utility utility) {
        try {
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (optional.isPresent()) {
                return ModuleJsonUtil.parseModuleType(optional.get()).equals(BUNDLE_TYPE_SHARE) && !ModuleJsonUtil.parseAbilityNames(optional.get()).isEmpty();
            }
            LOG.error("CompressVerify::hspHasAbilities jsonPath content invalid");
            return false;
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::hspHasAbilities exception: " + bundleException.getMessage());
            return false;
        }
    }

    private static boolean hspHasExtensionAbilities(Utility utility) {
        try {
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (optional.isPresent()) {
                return ModuleJsonUtil.parseModuleType(optional.get()).equals(BUNDLE_TYPE_SHARE) && !ModuleJsonUtil.parseExtensionAbilityName(optional.get()).isEmpty();
            }
            LOG.error("CompressVerify::hspHasExtensionAbilities jsonPath content invalid");
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::hspHasExtensionAbilities exception: " + bundleException.getMessage());
        }
        return false;
    }

    private static boolean hasHomeAbility(Utility utility) {
        try {
            boolean bl = false;
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (!optional.isPresent()) {
                LOG.error("CompressVerify::hasHomeAbility jsonPath content invalid");
                return false;
            }
            Map<String, Boolean> map = ModuleJsonUtil.parseAbilitySkillsMap(optional.get());
            if (map.containsValue(true)) {
                bl = true;
            }
            LOG.info("CompressVerify::hasHomeAbilities result = " + bl);
            return bl;
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::hasHomeAbilities exception: " + bundleException.getMessage());
            return false;
        }
    }

    private static boolean isValidEncryptJsonFile(Utility utility) {
        if (!utility.getEncryptPath().isEmpty()) {
            File file = new File(utility.getEncryptPath());
            return file.isFile() && "encrypt.json".equals(file.getName());
        }
        return true;
    }

    private static boolean hasHomeExtensionAbility(Utility utility) {
        try {
            boolean bl = false;
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            if (!optional.isPresent()) {
                LOG.error("CompressVerify::hasHomeExtensionAbility jsonPath content invalid");
                return false;
            }
            Map<String, Boolean> map = ModuleJsonUtil.parseExtensionAbilitySkillsMap(optional.get());
            if (map.containsValue(true)) {
                bl = true;
            }
            LOG.info("CompressVerify::hasHomeExtensionAbility result = " + bl);
            return bl;
        }
        catch (BundleException bundleException) {
            LOG.error("CompressVerify::hasHomeExtensionAbility exception: " + bundleException.getMessage());
            return false;
        }
    }
}

