/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntoolcmd;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public final class ParamsTrustlist {
    public static final String OPTIONS = " [options]:";
    private static final List<String> COMMONDS = new ArrayList<String>();
    private static HashMap<String, List<String>> trustMap = new HashMap();

    private ParamsTrustlist() {
    }

    public static void generateTrustlist() {
        ClassLoader classLoader = ParamsTrustlist.class.getClassLoader();
        if (classLoader == null) {
            return;
        }
        String page = "help.txt";
        try (InputStream inputStream = classLoader.getResourceAsStream(page);){
            if (inputStream == null) {
                return;
            }
            try (InputStreamReader isr = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                ParamsTrustlist.readHelpParam(br);
            }
        }
        catch (IOException e) {
            CustomException.throwException(ERROR.READ_FILE_ERROR, SignToolErrMsg.FILE_READ_FAILED.toString(page));
        }
    }

    private static void readHelpParam(BufferedReader br) throws IOException {
        String str;
        String cmdStandBy = null;
        while ((str = br.readLine()) != null) {
            String param = str.trim();
            if (COMMONDS.contains(param)) {
                cmdStandBy = param;
                continue;
            }
            ParamsTrustlist.putTrustMap(cmdStandBy, param);
        }
    }

    private static void putTrustMap(String cmdStandBy, String param) {
        if (param.startsWith("-")) {
            String subParam = param.substring(0, param.indexOf(":")).trim();
            List trustLists = Optional.ofNullable(trustMap.get(cmdStandBy)).orElse(new ArrayList());
            trustLists.add(subParam);
            trustMap.put(cmdStandBy, trustLists);
        }
    }

    public static List<String> getTrustList(String commond) {
        ParamsTrustlist.generateTrustlist();
        String keyParam = commond + OPTIONS;
        return Optional.ofNullable(trustMap.get(keyParam)).orElse(new ArrayList());
    }

    static {
        COMMONDS.add("generate-keypair [options]:");
        COMMONDS.add("generate-csr [options]:");
        COMMONDS.add("generate-cert [options]:");
        COMMONDS.add("generate-ca [options]:");
        COMMONDS.add("generate-app-cert [options]:");
        COMMONDS.add("generate-profile-cert [options]:");
        COMMONDS.add("sign-profile [options]:");
        COMMONDS.add("verify-profile [options]:");
        COMMONDS.add("sign-app [options]:");
        COMMONDS.add("verify-app [options]:");
    }
}

