/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.zip.DataDescriptor;
import com.ohos.hapsigntool.zip.EntryType;
import com.ohos.hapsigntool.zip.ZipEntryHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ZipEntryData {
    public static final short HAS_DATA_DESCRIPTOR_MASK = 8;
    public static final short NOT_HAS_DATA_DESCRIPTOR_FLAG = 0;
    private ZipEntryHeader zipEntryHeader;
    private long fileOffset;
    private long fileSize;
    private DataDescriptor dataDescriptor;
    private long length;
    private EntryType type;
    private byte[] data;

    public void updateLength() {
        this.zipEntryHeader.updateLength();
        this.length = this.data != null ? (long)(this.zipEntryHeader.getLength() + this.data.length + (this.dataDescriptor == null ? 0 : 16)) : (long)this.zipEntryHeader.getLength() + this.fileSize + (long)(this.dataDescriptor == null ? 0 : 16);
    }

    public static ZipEntryData getZipEntry(File file, long entryOffset, long fileSize) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            boolean hasDesc;
            long offset = entryOffset;
            byte[] headBytes = FileUtils.readInputByOffsetAndLength(input, entryOffset, 30L);
            ZipEntryHeader entryHeader = ZipEntryHeader.getZipEntryHeader(headBytes);
            offset += 30L;
            if (entryHeader.getFileNameLength() > 0) {
                byte[] fileNameBytes = FileUtils.readInputByLength(input, entryHeader.getFileNameLength());
                entryHeader.readFileName(fileNameBytes);
                offset += (long)entryHeader.getFileNameLength();
            }
            if (entryHeader.getExtraLength() > 0) {
                byte[] extraBytes = FileUtils.readInputByLength(input, entryHeader.getExtraLength());
                entryHeader.readExtra(extraBytes);
                offset += (long)entryHeader.getExtraLength();
            }
            ZipEntryData entry = new ZipEntryData();
            entry.setFileOffset(offset);
            entry.setFileSize(fileSize);
            input.skip(fileSize);
            if (FileUtils.isRunnableFile(entryHeader.getFileName())) {
                entry.setType(EntryType.RUNNABLE_FILE);
            } else if (".pages.info".equals(entryHeader.getFileName())) {
                entry.setType(EntryType.BIT_MAP);
            } else {
                entry.setType(EntryType.RESOURCE_FILE);
            }
            long entryLength = (long)entryHeader.getLength() + fileSize;
            short flag = entryHeader.getFlag();
            boolean bl = hasDesc = (flag & 8) != 0;
            if (hasDesc) {
                byte[] desBytes = FileUtils.readInputByLength(input, 16L);
                DataDescriptor dataDesc = DataDescriptor.getDataDescriptor(desBytes);
                entryLength += 16L;
                entry.setDataDescriptor(dataDesc);
            }
            entry.setZipEntryHeader(entryHeader);
            entry.setLength(entryLength);
            ZipEntryData zipEntryData = entry;
            return zipEntryData;
        }
    }

    public void setZipEntryHeader(ZipEntryHeader zipEntryHeader) {
        this.zipEntryHeader = zipEntryHeader;
    }

    public ZipEntryHeader getZipEntryHeader() {
        return this.zipEntryHeader;
    }

    public DataDescriptor getDataDescriptor() {
        return this.dataDescriptor;
    }

    public void setDataDescriptor(DataDescriptor dataDescriptor) {
        this.dataDescriptor = dataDescriptor;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public EntryType getType() {
        return this.type;
    }

    public void setType(EntryType type) {
        this.type = type;
    }
}

