/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.zip.CentralDirectory;
import com.ohos.hapsigntool.zip.EntryType;
import com.ohos.hapsigntool.zip.ZipEntryData;
import com.ohos.hapsigntool.zip.ZipEntryHeader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.zip.CRC32;

public class ZipEntry {
    private ZipEntryData zipEntryData;
    private CentralDirectory fileEntryInCentralDirectory;

    public void updateLength() {
        this.zipEntryData.updateLength();
        this.fileEntryInCentralDirectory.updateLength();
    }

    public int alignment(int alignNum) throws ZipException {
        int padding = this.calZeroPaddingLengthForEntryExtra();
        int remainder = (int)(((long)this.zipEntryData.getZipEntryHeader().getLength() + this.fileEntryInCentralDirectory.getOffset()) % (long)alignNum);
        if (remainder == 0) {
            return padding;
        }
        int add = alignNum - remainder;
        int newExtraLength = this.zipEntryData.getZipEntryHeader().getExtraLength() + add;
        if (newExtraLength > 65535) {
            throw new ZipException("can not align " + this.zipEntryData.getZipEntryHeader().getFileName());
        }
        this.setEntryHeaderNewExtraLength(newExtraLength);
        this.setCenterDirectoryNewExtraLength(newExtraLength);
        return add;
    }

    private int calZeroPaddingLengthForEntryExtra() throws ZipException {
        int entryExtraLen = this.zipEntryData.getZipEntryHeader().getExtraLength();
        int cdExtraLen = this.fileEntryInCentralDirectory.getExtraLength();
        if (cdExtraLen > entryExtraLen) {
            this.setEntryHeaderNewExtraLength(cdExtraLen);
            return cdExtraLen - entryExtraLen;
        }
        if (cdExtraLen < entryExtraLen) {
            this.setCenterDirectoryNewExtraLength(entryExtraLen);
            return entryExtraLen - cdExtraLen;
        }
        return 0;
    }

    private void setCenterDirectoryNewExtraLength(int newLength) throws ZipException {
        byte[] newCDExtra = this.getAlignmentNewExtra(newLength, this.fileEntryInCentralDirectory.getExtraData());
        this.fileEntryInCentralDirectory.setExtraData(newCDExtra);
        this.fileEntryInCentralDirectory.setExtraLength(newLength);
        this.fileEntryInCentralDirectory.setLength(46 + this.fileEntryInCentralDirectory.getFileNameLength() + this.fileEntryInCentralDirectory.getExtraLength() + this.fileEntryInCentralDirectory.getCommentLength());
    }

    private void setEntryHeaderNewExtraLength(int newLength) throws ZipException {
        ZipEntryHeader zipEntryHeader = this.zipEntryData.getZipEntryHeader();
        byte[] newExtra = this.getAlignmentNewExtra(newLength, zipEntryHeader.getExtraData());
        zipEntryHeader.setExtraData(newExtra);
        zipEntryHeader.setExtraLength(newLength);
        zipEntryHeader.setLength(30 + zipEntryHeader.getExtraLength() + zipEntryHeader.getFileNameLength());
        this.zipEntryData.setLength((long)zipEntryHeader.getLength() + this.zipEntryData.getFileSize() + (long)(this.zipEntryData.getDataDescriptor() == null ? 0 : 16));
    }

    private byte[] getAlignmentNewExtra(int newLength, byte[] old) throws ZipException {
        if (old == null) {
            return new byte[newLength];
        }
        if (newLength < old.length) {
            throw new ZipException("can not align " + this.zipEntryData.getZipEntryHeader().getFileName());
        }
        return Arrays.copyOf(old, newLength);
    }

    public ZipEntryData getZipEntryData() {
        return this.zipEntryData;
    }

    public void setZipEntryData(ZipEntryData zipEntryData) {
        this.zipEntryData = zipEntryData;
    }

    public CentralDirectory getCentralDirectory() {
        return this.fileEntryInCentralDirectory;
    }

    public void setCentralDirectory(CentralDirectory centralDirectory) {
        this.fileEntryInCentralDirectory = centralDirectory;
    }

    public static class Builder {
        private short version = (short)10;
        private short flag = (short)2048;
        private short method = 0;
        private long compressedSize;
        private long unCompressedSize;
        private String fileName;
        private byte[] extraData;
        private byte[] comment;
        private byte[] data;

        public Builder setVersion(short version) {
            this.version = version;
            return this;
        }

        public Builder setFlag(short flag) {
            this.flag = flag;
            return this;
        }

        public Builder setMethod(short method) {
            this.method = method;
            return this;
        }

        public Builder setCompressedSize(long compressedSize) {
            this.compressedSize = compressedSize;
            return this;
        }

        public Builder setUncompressedSize(long unCompressedSize) {
            this.unCompressedSize = unCompressedSize;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setExtraData(byte[] extraData) {
            this.extraData = extraData;
            return this;
        }

        public Builder setComment(byte[] comment) {
            this.comment = comment;
            return this;
        }

        public Builder setData(byte[] data) {
            this.data = data;
            return this;
        }

        public ZipEntry build() throws ZipException {
            Calendar calendar = Calendar.getInstance();
            int time = calendar.get(1) - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
            CentralDirectory cd = this.addCenterDirectory(time);
            ZipEntryHeader zipEntryHeader = this.addZipEntryHeader(time);
            if (this.data == null) {
                throw new ZipException("can not find entry data");
            }
            CRC32 c = new CRC32();
            c.update(this.data);
            int crc32 = new Long(c.getValue()).intValue();
            cd.setCrc32(crc32);
            zipEntryHeader.setCrc32(crc32);
            ZipEntryData entryData = new ZipEntryData();
            entryData.setData(this.data);
            entryData.setZipEntryHeader(zipEntryHeader);
            ZipEntry entry = new ZipEntry();
            entry.setZipEntryData(entryData);
            entryData.setType(EntryType.BIT_MAP);
            entry.setCentralDirectory(cd);
            return entry;
        }

        private CentralDirectory addCenterDirectory(int time) {
            CentralDirectory cd = new CentralDirectory();
            cd.setVersion(this.version);
            cd.setVersionExtra(this.version);
            cd.setFlag(this.flag);
            cd.setMethod(this.method);
            cd.setLastTime((short)time);
            cd.setLastDate((short)(time >> 16));
            cd.setCompressedSize(this.compressedSize);
            cd.setUnCompressedSize(this.unCompressedSize);
            cd.setFileName(this.fileName);
            cd.setFileNameLength(this.fileName.length());
            if (this.extraData != null) {
                cd.setExtraData(this.extraData);
                cd.setExtraLength(this.extraData.length);
            } else {
                cd.setExtraLength(0);
            }
            if (this.comment != null) {
                cd.setComment(this.comment);
                cd.setCommentLength(this.comment.length);
            } else {
                cd.setCommentLength(0);
            }
            cd.setDiskNumStart(0);
            cd.setExternalFile(0);
            cd.updateLength();
            return cd;
        }

        private ZipEntryHeader addZipEntryHeader(int time) {
            ZipEntryHeader zipEntryHeader = new ZipEntryHeader();
            zipEntryHeader.setVersion(this.version);
            zipEntryHeader.setFlag(this.flag);
            zipEntryHeader.setMethod(this.method);
            zipEntryHeader.setLastTime((short)time);
            zipEntryHeader.setLastDate((short)(time >> 16));
            zipEntryHeader.setCompressedSize(this.compressedSize);
            zipEntryHeader.setUnCompressedSize(this.unCompressedSize);
            zipEntryHeader.setFileName(this.fileName);
            zipEntryHeader.setFileNameLength(this.fileName.length());
            if (this.extraData != null) {
                zipEntryHeader.setExtraData(this.extraData);
                zipEntryHeader.setExtraLength(this.extraData.length);
            } else {
                zipEntryHeader.setExtraLength(0);
            }
            zipEntryHeader.updateLength();
            return zipEntryHeader;
        }
    }
}

