/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipDataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFileZipDataInput
implements ZipDataInput {
    private static final int MAX_READ_BLOCK_SIZE = 0x100000;
    private final RandomAccessFile file;
    private final FileChannel fileChannel;
    private final long startIndex;
    private final long size;

    public RandomAccessFileZipDataInput(RandomAccessFile file) {
        this.file = file;
        this.fileChannel = file.getChannel();
        this.startIndex = 0L;
        this.size = -1L;
    }

    public RandomAccessFileZipDataInput(RandomAccessFile file, long offset, long size) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        this.file = file;
        this.fileChannel = file.getChannel();
        this.startIndex = offset;
        this.size = size;
    }

    @Override
    public long size() {
        if (this.size == -1L) {
            try {
                return this.file.length();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long offset, long size, ZipDataOutput output) throws IOException {
        int blockSize;
        long srcSize = this.size();
        this.checkBoundValid(offset, size, srcSize);
        if (size == 0L) {
            return;
        }
        long offsetInFile = this.startIndex + offset;
        byte[] buf = new byte[0x100000];
        for (long remaining = size; remaining > 0L; remaining -= (long)blockSize) {
            blockSize = (int)Math.min(remaining, (long)buf.length);
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                this.file.seek(offsetInFile);
                this.file.readFully(buf, 0, blockSize);
                output.write(buf, 0, blockSize);
            }
            offsetInFile += (long)blockSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long offset, int size, ByteBuffer buffer) throws IOException {
        long srcSize = this.size();
        this.checkBoundValid(offset, size, srcSize);
        if (size == 0) {
            return;
        }
        if (size > buffer.remaining()) {
            throw new BufferOverflowException();
        }
        long offsetInFile = this.startIndex + offset;
        int originalLimit = buffer.limit();
        try {
            int readSize;
            buffer.limit(buffer.position() + size);
            for (int remaining = size; remaining > 0; remaining -= readSize) {
                RandomAccessFile randomAccessFile = this.file;
                synchronized (randomAccessFile) {
                    this.fileChannel.position(offsetInFile);
                    readSize = this.fileChannel.read(buffer);
                }
                offsetInFile += (long)readSize;
            }
        }
        finally {
            buffer.limit(originalLimit);
        }
    }

    @Override
    public ByteBuffer createByteBuffer(long offset, int size) throws IOException {
        if (size < 0) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.copyTo(offset, size, buffer);
        buffer.flip();
        return buffer;
    }

    @Override
    public ZipDataInput slice(long offset, long size) {
        long srcSize = this.size();
        this.checkBoundValid(offset, size, srcSize);
        if (offset == 0L && size == srcSize) {
            return this;
        }
        return new RandomAccessFileZipDataInput(this.file, offset + this.startIndex, size);
    }

    private void checkBoundValid(long offset, long size, long sourceSize) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        if (offset > sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > sourceSize (" + sourceSize + ")");
        }
        long endOffset = offset + size;
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
        }
        if (endOffset > sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > sourceSize (" + sourceSize + ")");
        }
    }
}

