/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DataDescriptor {
    public static final int DES_LENGTH = 16;
    public static final int SIGNATURE = 134695760;
    private int crc32;
    private long compressedSize;
    private long unCompressedSize;

    public static DataDescriptor getDataDescriptor(byte[] bytes) throws ZipException {
        if (bytes.length != 16) {
            throw new ZipException("read Data Descriptor failed");
        }
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        DataDescriptor data = new DataDescriptor();
        if (bf.getInt() != 134695760) {
            throw new ZipException("read Data Descriptor failed");
        }
        data.setCrc32(bf.getInt());
        data.setCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        data.setUnCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        return data;
    }

    public byte[] toBytes() {
        ByteBuffer bf = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(134695760);
        bf.putInt(this.crc32);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.compressedSize);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.unCompressedSize);
        return bf.array();
    }

    public static int getDesLength() {
        return 16;
    }

    public static int getSIGNATURE() {
        return 134695760;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public long getUnCompressedSize() {
        return this.unCompressedSize;
    }

    public void setUnCompressedSize(long unCompressedSize) {
        this.unCompressedSize = unCompressedSize;
    }
}

