/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.utils.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ParamProcessUtil {
    private static final LogUtils LOGGER = new LogUtils(ParamProcessUtil.class);

    private ParamProcessUtil() {
    }

    public static Set<String> initParamField(String[] paramFileds) {
        return new HashSet<String>(Arrays.asList(paramFileds));
    }

    public static void delDir(File file) {
        File[] zFiles;
        if (file.isDirectory() && (zFiles = file.listFiles()) != null) {
            for (File file2 : zFiles) {
                ParamProcessUtil.delDir(file2);
            }
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            LOGGER.warn("delete files failed!");
        }
    }

    public static SignatureAlgorithm getSignatureAlgorithm(String signatureAlgorithm) {
        SignatureAlgorithm result;
        if ("SHA256withECDSA".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.ECDSA_WITH_SHA256;
        } else if ("SHA384withECDSA".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.ECDSA_WITH_SHA384;
        } else if ("SHA512withECDSA".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.ECDSA_WITH_SHA512;
        } else if ("SHA256withRSA/PSS".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA256;
        } else if ("SHA384withRSA/PSS".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA384;
        } else if ("SHA512withRSA/PSS".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA512;
        } else if ("SHA256withRSAANDMGF1".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA256;
        } else if ("SHA384withRSAANDMGF1".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA384;
        } else if ("SHA512withRSAANDMGF1".equalsIgnoreCase(signatureAlgorithm)) {
            result = SignatureAlgorithm.RSA_PSS_WITH_SHA512;
        } else {
            throw new IllegalArgumentException("Unsupported signature algorithm: " + signatureAlgorithm);
        }
        return result;
    }
}

