/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.ohos.hapsigntool.error.LogConfigException;
import com.ohos.hapsigntool.utils.LogFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogUtils {
    private static Level level;
    private static final Map<String, Level> LEVEL_MAP;
    private static final String DEFAULT_LEVEL = "info";
    private static final Pattern PATTERN;
    private static final Handler OUT_HANDLER;
    private static final Handler ERR_HANDLER;
    private final Logger logger;

    public LogUtils(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz.getName());
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(OUT_HANDLER);
        this.logger.addHandler(ERR_HANDLER);
        this.logger.setLevel(level);
    }

    public void info(String log) {
        this.logger.info(" INFO - " + log);
        OUT_HANDLER.flush();
    }

    public void info(String log, Object arg) {
        this.logger.info(" INFO - " + LogUtils.replaceArgs(log, arg));
        OUT_HANDLER.flush();
    }

    public void info(String log, Object arg1, Object arg2) {
        this.logger.info(" INFO - " + LogUtils.replaceArgs(log, arg1, arg2));
        OUT_HANDLER.flush();
    }

    public void warn(String log) {
        this.logger.warning(" WARN - " + log);
        ERR_HANDLER.flush();
    }

    public void warn(String log, Object arg) {
        this.logger.warning(" WARN - " + LogUtils.replaceArgs(log, arg));
        ERR_HANDLER.flush();
    }

    public void warn(String log, Object arg, Throwable e) {
        this.logger.log(Level.WARNING, e, () -> " DEBUG - " + LogUtils.replaceArgs(log, arg));
        ERR_HANDLER.flush();
    }

    public void warn(String log, Object arg1, Object arg2) {
        this.logger.warning(" WARN - " + LogUtils.replaceArgs(log, arg1, arg2));
        ERR_HANDLER.flush();
    }

    public void warn(String log, Throwable e) {
        this.logger.log(Level.WARNING, e, () -> " DEBUG - " + log);
        ERR_HANDLER.flush();
    }

    public void debug(String log) {
        this.logger.config(" DEBUG - " + log);
        OUT_HANDLER.flush();
    }

    public void debug(String log, Object arg1, Object arg2) {
        this.logger.config(" DEBUG - " + LogUtils.replaceArgs(log, arg1, arg2));
        OUT_HANDLER.flush();
    }

    public void debug(String log, Throwable e) {
        this.logger.log(Level.CONFIG, e, () -> " DEBUG - " + log);
        OUT_HANDLER.flush();
    }

    public void debug(String log, Object arg) {
        this.logger.config(" DEBUG - " + LogUtils.replaceArgs(log, arg));
        OUT_HANDLER.flush();
    }

    public void error(String log) {
        this.logger.severe(" ERROR - " + log);
        ERR_HANDLER.flush();
    }

    public void error(String log, Throwable e) {
        this.logger.log(Level.SEVERE, e, () -> " ERROR - " + log);
        ERR_HANDLER.flush();
    }

    public void error(String log, Object arg, Throwable e) {
        this.logger.log(Level.SEVERE, e, () -> " ERROR - " + LogUtils.replaceArgs(log, arg));
        ERR_HANDLER.flush();
    }

    public void error(String log, Object arg) {
        this.logger.severe(" ERROR - " + LogUtils.replaceArgs(log, arg));
        ERR_HANDLER.flush();
    }

    public void error(String log, Object arg1, Object arg2) {
        this.logger.severe(" ERROR - " + LogUtils.replaceArgs(log, arg1, arg2));
        ERR_HANDLER.flush();
    }

    public void error(String log, Object arg1, Object arg2, Object arg3) {
        this.logger.severe(" ERROR - " + LogUtils.replaceArgs(log, arg1, arg2, arg3));
        ERR_HANDLER.flush();
    }

    private static String replaceArgs(String line, Object ... args) {
        Matcher matcher = PATTERN.matcher(line);
        String result = line;
        if (!matcher.find()) {
            return line;
        }
        for (Object arg : args) {
            Matcher m = PATTERN.matcher(result);
            result = m.replaceFirst(String.valueOf(arg));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarConfig(String configFileName) throws LogConfigException {
        String parent = LogUtils.getJarDirectory();
        if (parent == null) {
            throw new LogConfigException("get jar Parent failed");
        }
        File config = new File(parent, configFileName);
        if (!config.exists()) {
            throw new LogConfigException("can not find config file");
        }
        try (FileInputStream fis = new FileInputStream(config);){
            String string = LogUtils.getLogLevel(fis);
            return string;
        }
        catch (IOException e) {
            throw new LogConfigException("read config file failed");
        }
    }

    private static String getJarDirectory() throws LogConfigException {
        ProtectionDomain protectionDomain = LogUtils.class.getProtectionDomain();
        if (protectionDomain == null) {
            throw new LogConfigException("get jar protect domain failed");
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            throw new LogConfigException("read jar code path failed");
        }
        URL location = codeSource.getLocation();
        if (location == null) {
            throw new LogConfigException("read jar code source location failed");
        }
        String jarPath = location.getFile();
        if (jarPath == null) {
            throw new LogConfigException("read jar path failed");
        }
        return new File(jarPath).getParent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDefaultLogLevel(String configFileName) {
        try (InputStream inputStream = LogUtils.class.getClassLoader().getResourceAsStream(configFileName);){
            if (inputStream == null) {
                String string2 = DEFAULT_LEVEL;
                return string2;
            }
            String string = LogUtils.getLogLevel(inputStream);
            return string;
        }
        catch (IOException e) {
            return DEFAULT_LEVEL;
        }
    }

    private static String getLogLevel(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        Object levelConfig = prop.get("level");
        if (levelConfig instanceof String) {
            return (String)levelConfig;
        }
        return DEFAULT_LEVEL;
    }

    static {
        LEVEL_MAP = new HashMap<String, Level>();
        PATTERN = Pattern.compile("\\{}");
        LEVEL_MAP.put(DEFAULT_LEVEL, Level.INFO);
        LEVEL_MAP.put("debug", Level.CONFIG);
        LEVEL_MAP.put("warn", Level.WARNING);
        LEVEL_MAP.put("error", Level.SEVERE);
        String configFileName = "log.properties";
        try {
            level = LEVEL_MAP.get(LogUtils.getJarConfig(configFileName));
        }
        catch (LogConfigException e) {
            level = LEVEL_MAP.get(LogUtils.getDefaultLogLevel(configFileName));
        }
        LogFormatter logFormatter = new LogFormatter();
        OUT_HANDLER = new StreamHandler(System.out, logFormatter);
        OUT_HANDLER.setFilter(record -> record.getLevel() != Level.SEVERE && record.getLevel() != Level.WARNING);
        OUT_HANDLER.setLevel(level);
        ERR_HANDLER = new StreamHandler(System.err, logFormatter);
        ERR_HANDLER.setLevel(Level.WARNING);
    }
}

