/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class FileUtils {
    private static final LogUtils LOGGER = new LogUtils(FileUtils.class);
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Gson GSON_PRETTY_PRINT = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final int FILE_BUFFER_BLOCK = 0x100000;
    public static final int FILE_END = -1;
    public static final int SPLIT_LENGTH = 2;
    public static final String LIBS_PATH_PREFIX = "libs/";
    public static final String ABC_FILE_SUFFIX = ".abc";
    public static final String NATIVE_LIB_AN_SUFFIX = ".an";
    public static final String BIT_MAP_FILENAME = ".pages.info";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private FileUtils() {
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                LOGGER.debug(exception.getMessage(), exception);
            }
        }
    }

    public static byte[] readFile(File file) throws IOException {
        return FileUtils.read(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    /*
     * Loose catch block
     */
    public static byte[] read(InputStream input) throws IOException {
        try {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int read;
                byte[] buffer = new byte[0x100000];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                byte[] byArray = output.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.close(input);
        }
    }

    public static byte[] readFileByOffsetAndLength(File file, long offset, long length) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] byArray = FileUtils.readInputByOffsetAndLength(input, offset, length);
            return byArray;
        }
    }

    public static byte[] readInputByOffsetAndLength(InputStream input, long offset, long length) throws IOException {
        input.skip(offset);
        return FileUtils.readInputByLength(input, length);
    }

    public static byte[] readInputByLength(InputStream input, long length) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            if (length > Integer.MAX_VALUE) {
                throw new IOException("Size cannot be greater than Integer max value: " + length);
            }
            FileUtils.writeInputToOutPut(input, output, length);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    private static void writeInputToOutPut(InputStream input, OutputStream output, long length) throws IOException {
        int len;
        byte[] buffer = new byte[0x100000];
        for (long hasReadLen = 0L; hasReadLen < length; hasReadLen += (long)len) {
            int readLen = (int)Math.min(length - hasReadLen, 0x100000L);
            len = input.read(buffer, 0, readLen);
            if (len != readLen) {
                throw new IOException("read" + hasReadLen + "bytes data less than " + length);
            }
            output.write(buffer, 0, len);
        }
    }

    public static void write(byte[] content, File output) throws IOException {
        if (output.exists() && !output.canWrite()) {
            CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.FILE_WRITE_FAILED.toString("No permission write to file " + output));
        }
        try (FileOutputStream out = new FileOutputStream(output);){
            for (byte con : content) {
                out.write(con);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean appendWriteFileByOffsetToFile(String inFile, FileOutputStream out, long offset, long size) {
        File inputFile = new File(inFile);
        try (FileInputStream fis = new FileInputStream(inputFile);){
            fis.skip(offset);
            FileUtils.writeInputToOutPut(fis, out, size);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get input stream object.");
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read or write data.");
        }
        return false;
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).exists();
    }

    public static void validFileType(String filePath, String ... types) {
        String suffix = FileUtils.getSuffix(filePath);
        ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(suffix), ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.NOT_SUPPORT_FILE.toString(filePath));
        boolean isMatches = false;
        for (String type : types) {
            if (StringUtils.isEmpty(type) || !type.equalsIgnoreCase(suffix)) continue;
            isMatches = true;
            break;
        }
        ValidateUtils.throwIfNotMatches(isMatches, ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.NOT_SUPPORT_FILE.toString(filePath));
    }

    public static String getSuffix(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return "";
        }
        File file = new File(filePath);
        String fileName = file.getName();
        String[] temps = fileName.split("\\.");
        if (temps.length < 2) {
            return "";
        }
        return temps[temps.length - 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFileToDos(String file, DataOutputStream dos) {
        if (dos == null) {
            return false;
        }
        File src = new File(file);
        try (FileInputStream fileStream = new FileInputStream(src);){
            int temp;
            byte[] buf = new byte[0x100000];
            while ((temp = fileStream.read(buf)) > 0) {
                dos.write(buf, 0, temp);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get input stream object.");
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read or write data.");
        }
        return false;
    }

    public static boolean writeByteToDos(byte[] data, DataOutputStream dos) {
        if (data == null) {
            return true;
        }
        try {
            dos.write(data);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write data to output stream.");
            return false;
        }
        return true;
    }

    public static long getFileLen(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeByteToOutFile(byte[] bytes, String outFile) {
        try (FileOutputStream ops = new FileOutputStream(outFile, true);){
            boolean bl = FileUtils.writeByteToOutFile(bytes, ops);
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get output stream object, outfile: " + outFile);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to write data to ops, outfile: " + outFile);
        }
        return false;
    }

    public static boolean writeByteToOutFile(byte[] bytes, OutputStream outFile) {
        try {
            outFile.write(bytes, 0, bytes.length);
            outFile.flush();
            return true;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get output stream object, outfile: " + outFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write data to ops, outfile: " + outFile);
        }
        return false;
    }

    public static void isValidFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("File '" + file + "' exists but is a directory");
        }
        if (!file.canRead()) {
            throw new IOException("File '" + file + "' cannot be read");
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        FileUtils.isValidFile(file);
        return new FileInputStream(file);
    }

    private static byte[] toByteArray(InputStream input, int size) throws IOException {
        int offset;
        int read;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (read = input.read(data, offset, size - offset)) != -1; offset += read) {
        }
        if (offset != size) {
            throw new IOException("Unexpected read size. current: " + offset + ", expected: " + size);
        }
        return data;
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        try (FileInputStream in = FileUtils.openInputStream(file);){
            long fileLength = file.length();
            if (fileLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + fileLength);
            }
            byte[] byArray = FileUtils.toByteArray(in, (int)fileLength);
            return byArray;
        }
    }

    public static void writeStringToFile(String source, String filePath, Charset charset) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), charset));){
            writer.write(source);
            writer.flush();
        }
    }

    public static void deleteFile(File file) {
        if (file != null && file.isFile()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.warn("delete file '{}' error, error message: {}", (Object)file, e.getMessage());
            }
        }
    }

    public static boolean isRunnableFile(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        if (name.endsWith(NATIVE_LIB_AN_SUFFIX) || name.endsWith(ABC_FILE_SUFFIX)) {
            return true;
        }
        return name.startsWith(LIBS_PATH_PREFIX);
    }
}

