/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.sign;

import com.ohos.hapsigntool.entity.ContentDigestAlgorithm;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.error.SignatureException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.hap.sign.Pkcs7Generator;
import com.ohos.hapsigntool.hap.utils.HapUtils;
import com.ohos.hapsigntool.zip.ZipDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SignHap {
    private static final int BLOCK_COUNT = 4;
    private static final int BLOCK_MAGIC = 16;
    private static final int BLOCK_VERSION = 4;
    private static final int OPTIONAL_TYPE_SIZE = 4;
    private static final int OPTIONAL_LENGTH_SIZE = 4;
    private static final int OPTIONAL_OFFSET_SIZE = 4;

    private SignHap() {
    }

    private static byte[] getHapSigningBlock(Set<ContentDigestAlgorithm> contentDigestAlgorithms, List<SigningBlock> optionalBlocks, SignerConfig signerConfig, ZipDataInput[] hapData) throws SignatureException {
        byte[] hapSignatureBytes = null;
        try {
            Map<ContentDigestAlgorithm, byte[]> contentDigests = HapUtils.computeDigests(contentDigestAlgorithms, hapData, optionalBlocks);
            hapSignatureBytes = SignHap.generateHapSigningBlock(signerConfig, contentDigests, optionalBlocks);
        }
        catch (IOException | DigestException e) {
            throw new SignatureException("Failed to compute digests of HAP", e);
        }
        return hapSignatureBytes;
    }

    private static byte[] generateHapSigningBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests, List<SigningBlock> optionalBlocks) throws SignatureException {
        byte[] hapSignatureSchemeBlock = SignHap.generateHapSignatureSchemeBlock(signerConfig, contentDigests);
        return SignHap.generateHapSigningBlock(hapSignatureSchemeBlock, optionalBlocks, signerConfig.getCompatibleVersion());
    }

    private static byte[] generateHapSigningBlock(byte[] hapSignatureSchemeBlock, List<SigningBlock> optionalBlocks, int compatibleVersion) {
        long optionalBlockSize = 0L;
        for (SigningBlock optionalBlock : optionalBlocks) {
            optionalBlockSize += (long)optionalBlock.getLength();
        }
        long resultSize = (long)(12 * (optionalBlocks.size() + 1)) + optionalBlockSize + (long)hapSignatureSchemeBlock.length + 4L + 8L + 16L + 4L;
        if (resultSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HapSigningBlock out of range : " + resultSize);
        }
        ByteBuffer result = ByteBuffer.allocate((int)resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        HashMap<Integer, Integer> typeAndOffsetMap = new HashMap<Integer, Integer>();
        int currentOffset = 12 * (optionalBlocks.size() + 1);
        int currentOffsetInBlockValue = 0;
        int blockValueSizes = (int)(optionalBlockSize + (long)hapSignatureSchemeBlock.length);
        byte[] blockValues = new byte[blockValueSizes];
        for (SigningBlock optionalBlock : optionalBlocks) {
            System.arraycopy(optionalBlock.getValue(), 0, blockValues, currentOffsetInBlockValue, optionalBlock.getLength());
            typeAndOffsetMap.put(optionalBlock.getType(), currentOffset);
            currentOffset += optionalBlock.getLength();
            currentOffsetInBlockValue += optionalBlock.getLength();
        }
        System.arraycopy(hapSignatureSchemeBlock, 0, blockValues, currentOffsetInBlockValue, hapSignatureSchemeBlock.length);
        typeAndOffsetMap.put(0x20000000, currentOffset);
        SignHap.extractedResult(optionalBlocks, result, typeAndOffsetMap);
        result.putInt(0x20000000);
        result.putInt(hapSignatureSchemeBlock.length);
        int offset = (Integer)typeAndOffsetMap.get(0x20000000);
        result.putInt(offset);
        result.put(blockValues);
        result.putInt(optionalBlocks.size() + 1);
        result.putLong(resultSize);
        result.put(HapUtils.getHapSigningBlockMagic(compatibleVersion));
        result.putInt(HapUtils.getHapSigningBlockVersion(compatibleVersion));
        return result.array();
    }

    private static void extractedResult(List<SigningBlock> optionalBlocks, ByteBuffer result, Map<Integer, Integer> typeAndOffsetMap) {
        for (SigningBlock optionalBlock : optionalBlocks) {
            result.putInt(optionalBlock.getType());
            result.putInt(optionalBlock.getLength());
            int offset = typeAndOffsetMap.get(optionalBlock.getType());
            result.putInt(offset);
        }
    }

    private static byte[] generateHapSignatureSchemeBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        byte[] signerBlock = null;
        try {
            signerBlock = SignHap.generateSignerBlock(signerConfig, contentDigests);
        }
        catch (SignatureException e) {
            throw new SignatureException("generate SignerBlock failed\nSolutions:\n> The keyAlias parameter is incorrect, please input a correct keyAlias parameter.\n> The certificate is incorrect, please check if your certificate matches the key");
        }
        return signerBlock;
    }

    private static byte[] generateSignerBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        String mode = signerConfig.getOptions().getString("mode");
        if (!"remoteSign".equalsIgnoreCase(mode) && signerConfig.getCertificates().isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>(signerConfig.getSignatureAlgorithms().size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.getSignatureAlgorithms()) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] contentDigest = contentDigests.get((Object)contentDigestAlgorithm);
            if (contentDigest == null) {
                throw new SignatureException(contentDigestAlgorithm.getDigestAlgorithm() + " content digest for " + signatureAlgorithm.getSignatureAlgAndParams().getFirst() + " not computed");
            }
            digests.add(Pair.create(signatureAlgorithm.getId(), contentDigest));
        }
        byte[] unsignedHapDigest = HapUtils.encodeListOfPairsToByteArray(digests);
        return Pkcs7Generator.BC.generateSignedData(unsignedHapDigest, signerConfig);
    }

    public static byte[] sign(ZipDataInput[] contents, SignerConfig signerConfig, List<SigningBlock> optionalBlocks) throws SignatureException {
        HashSet<ContentDigestAlgorithm> contentDigestAlgorithms = new HashSet<ContentDigestAlgorithm>();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.getSignatureAlgorithms()) {
            contentDigestAlgorithms.add(signatureAlgorithm.getContentDigestAlgorithm());
        }
        return SignHap.getHapSigningBlock(contentDigestAlgorithms, optionalBlocks, signerConfig, contents);
    }
}

