/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.config;

import com.ohos.hapsigntool.adapter.LocalizationAdapter;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.signer.ISigner;
import com.ohos.hapsigntool.signer.SignerFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignerConfig {
    private Options options;
    private List<X509Certificate> certificates;
    private List<X509CRL> x509CRLs;
    private List<SignatureAlgorithm> signatureAlgorithms;
    private Map<String, String> signParamMap = new HashMap<String, String>();
    private ISigner signer;
    private int compatibleVersion;

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public List<X509Certificate> getCertificates() {
        if (this.isInputCertChainNotEmpty() || this.signer == null) {
            return this.certificates;
        }
        return this.signer.getCertificates();
    }

    public void setCertificates(List<X509Certificate> certificates) {
        this.certificates = certificates;
    }

    public List<X509CRL> getX509CRLs() {
        if (this.isInputCertChainNotEmpty() || this.isInputCrlNotEmpty() || this.signer == null) {
            return this.x509CRLs;
        }
        return this.signer.getCrls();
    }

    public void setX509CRLs(List<X509CRL> crls) {
        this.x509CRLs = crls;
    }

    public List<SignatureAlgorithm> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<SignatureAlgorithm> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public Map<String, String> getSignParamMap() {
        return this.signParamMap;
    }

    public void setParameters(Map<String, String> params) {
        this.signParamMap = params;
    }

    public ISigner getSigner() {
        if (this.signer == null) {
            this.signer = new SignerFactory().getSigner(new LocalizationAdapter(this.options));
        }
        return this.signer;
    }

    public int getCompatibleVersion() {
        return this.compatibleVersion;
    }

    public void setCompatibleVersion(int compatibleVersion) {
        this.compatibleVersion = compatibleVersion;
    }

    private boolean isInputCertChainNotEmpty() {
        return this.certificates != null && !this.certificates.isEmpty();
    }

    private boolean isInputCrlNotEmpty() {
        return this.x509CRLs != null && !this.x509CRLs.isEmpty();
    }

    public SignerConfig copy() {
        SignerConfig signerConfig = new SignerConfig();
        signerConfig.setParameters(this.signParamMap);
        signerConfig.setCertificates(this.certificates);
        signerConfig.setOptions(this.options);
        signerConfig.setSignatureAlgorithms(this.signatureAlgorithms);
        signerConfig.setCompatibleVersion(this.compatibleVersion);
        signerConfig.setX509CRLs(this.x509CRLs);
        signerConfig.getSigner();
        return signerConfig;
    }
}

