/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.utils.LogUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class HapUtils {
    public static final String HAP_DEBUG_OWNER_ID = "DEBUG_LIB_ID";
    public static final String HAP_SHARED_OWNER_ID = "SHARED_LIB_ID";
    private static final LogUtils LOGGER = new LogUtils(HapUtils.class);
    private static final String COMPRESS_NATIVE_LIBS_OPTION = "compressNativeLibs";
    private static final List<String> HAP_CONFIG_FILES = new ArrayList<String>();
    private static final String HAP_FA_CONFIG_JSON_FILE = "config.json";
    private static final String HAP_STAGE_MODULE_JSON_FILE = "module.json";
    private static final int MAX_APP_ID_LEN = 32;

    private HapUtils() {
    }

    public static String getAppIdentifier(String profileContent) throws ProfileException {
        Pair<String, String> resultPair = HapUtils.parseAppIdentifier(profileContent);
        String ownerID = resultPair.getFirst();
        String profileType = resultPair.getSecond();
        if ("debug".equals(profileType)) {
            return HAP_DEBUG_OWNER_ID;
        }
        if ("release".equals(profileType)) {
            return ownerID;
        }
        throw new ProfileException(CodeSignErrMsg.PROFILE_TYPE_UNSUPPORTED_ERROR.toString());
    }

    public static Pair<String, String> parseAppIdentifier(String profileContent) throws ProfileException {
        String ownerID = null;
        String profileType = null;
        try {
            JsonElement parser = JsonParser.parseString(profileContent);
            JsonObject profileJson = parser.getAsJsonObject();
            String profileTypeKey = "type";
            if (!profileJson.has(profileTypeKey)) {
                throw new ProfileException(CodeSignErrMsg.PROFILE_TYPE_NOT_EXISTED_ERROR.toString());
            }
            profileType = profileJson.get(profileTypeKey).getAsString();
            if (profileType == null || profileType.isEmpty()) {
                throw new ProfileException(CodeSignErrMsg.PROFILE_TYPE_NOT_EXISTED_ERROR.toString());
            }
            String appIdentifier = "app-identifier";
            String buildInfoMember = "bundle-info";
            JsonObject buildInfoObject = profileJson.getAsJsonObject(buildInfoMember);
            if (buildInfoObject == null) {
                throw new ProfileException(CodeSignErrMsg.PROFILE_BUNDLE_INFO_NOT_EXISTED_ERROR.toString());
            }
            if (buildInfoObject.has(appIdentifier)) {
                JsonElement ownerIDElement = buildInfoObject.get(appIdentifier);
                if (!ownerIDElement.getAsJsonPrimitive().isString()) {
                    throw new ProfileException(CodeSignErrMsg.PROFILE_APPID_VALUE_TYPE_ERROR.toString());
                }
                ownerID = ownerIDElement.getAsString();
                if (ownerID.isEmpty() || ownerID.length() > 32) {
                    throw new ProfileException(CodeSignErrMsg.PROFILE_APPID_VALUE_LENGTH_ERROR.toString());
                }
            }
        }
        catch (JsonSyntaxException | UnsupportedOperationException e) {
            throw new ProfileException(CodeSignErrMsg.PROFILE_JSON_PARSE_ERROR.toString(), e);
        }
        LOGGER.info("profile type is: {}", profileType);
        return Pair.create(ownerID, profileType);
    }

    public static String getPublicHnpOwnerId(String profileContent) {
        String profileTypeKey;
        String publicOwnerID = "";
        JsonElement parser = JsonParser.parseString(profileContent);
        JsonObject profileJson = parser.getAsJsonObject();
        JsonPrimitive profileType = profileJson.getAsJsonPrimitive(profileTypeKey = "type");
        if (profileType != null) {
            if ("debug".equals(profileType.getAsString())) {
                publicOwnerID = HAP_DEBUG_OWNER_ID;
            } else if ("release".equals(profileType.getAsString())) {
                publicOwnerID = HAP_SHARED_OWNER_ID;
            }
        }
        return publicOwnerID;
    }

    public static String parseHnpPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        CharSequence[] strings = path.split("/");
        if (strings.length < 3) {
            return "";
        }
        strings = Arrays.copyOfRange(strings, 2, strings.length);
        return String.join((CharSequence)"/", strings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getHnpsFromJson(JarFile inputJar) throws IOException, ProfileException {
        HashMap<String, String> hnpNameMap = new HashMap<String, String>();
        JarEntry moduleEntry = inputJar.getJarEntry(HAP_STAGE_MODULE_JSON_FILE);
        if (moduleEntry == null) {
            return hnpNameMap;
        }
        try (JsonReader reader = new JsonReader(new InputStreamReader(inputJar.getInputStream(moduleEntry), StandardCharsets.UTF_8));){
            JsonElement jsonElement = JsonParser.parseReader(reader);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject moduleObject = jsonObject.getAsJsonObject("module");
            JsonArray hnpPackageArr = moduleObject.getAsJsonArray("hnpPackages");
            if (hnpPackageArr == null || hnpPackageArr.isEmpty()) {
                LOGGER.debug("module.json has no hnpPackages key or hnpPackages value is empty");
                HashMap<String, String> hashMap = hnpNameMap;
                return hashMap;
            }
            hnpPackageArr.iterator().forEachRemaining(element -> {
                JsonObject hnpPackage = element.getAsJsonObject();
                JsonPrimitive hnpName = hnpPackage.getAsJsonPrimitive("package");
                if (hnpName == null || hnpName.getAsString().isEmpty()) {
                    return;
                }
                hnpNameMap.put(hnpName.getAsString(), "private");
                JsonPrimitive type = hnpPackage.getAsJsonPrimitive("type");
                if (type != null && !type.getAsString().isEmpty()) {
                    hnpNameMap.put(hnpName.getAsString(), type.getAsString());
                }
            });
            return hnpNameMap;
        }
        catch (JsonParseException e) {
            throw new ProfileException(CodeSignErrMsg.MODULE_JSON_PARSE_ERROR.toString(), e);
        }
    }

    static {
        HAP_CONFIG_FILES.add(HAP_FA_CONFIG_JSON_FILE);
        HAP_CONFIG_FILES.add(HAP_STAGE_MODULE_JSON_FILE);
    }
}

