/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.fsverity;

import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityHashAlgorithm;
import com.ohos.hapsigntool.codesigning.fsverity.MerkleTree;
import com.ohos.hapsigntool.codesigning.utils.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MerkleTreeBuilder
implements AutoCloseable {
    private static final int FSVERITY_HASH_PAGE_SIZE = 4096;
    private static final long INPUTSTREAM_MAX_SIZE = 0x10000000000000L;
    private static final int CHUNK_SIZE = 4096;
    private static final long MAX_READ_SIZE = 0x400000L;
    private static final int MAX_PROCESSORS = 32;
    private static final int BLOCKINGQUEUE = 4;
    private static final int POOL_SIZE = Math.min(32, Runtime.getRuntime().availableProcessors());
    private String mAlgorithm = "SHA-256";
    private final ExecutorService mPools = new ThreadPoolExecutor(POOL_SIZE, POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(4), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void close() {
        this.mPools.shutdownNow();
    }

    private void setAlgorithm(String algorithm) {
        this.mAlgorithm = algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transInputStreamToHashData(InputStream inputStream, long size, ByteBuffer outputBuffer) throws IOException {
        if (size == 0L) {
            throw new IOException(CodeSignErrMsg.CODE_SIGN_INTERNAL_ERROR.toString("Input size is empty"));
        }
        if (size > 0x10000000000000L) {
            throw new IOException(CodeSignErrMsg.CODE_SIGN_INTERNAL_ERROR.toString("Input size is too long"));
        }
        int count = (int)MerkleTreeBuilder.getChunkCount(size, 0x400000L);
        int chunks = (int)MerkleTreeBuilder.getChunkCount(size, 4096L);
        byte[][] hashes = new byte[chunks][];
        long readOffset = 0L;
        Phaser tasks = new Phaser(1);
        Class<MerkleTreeBuilder> clazz = MerkleTreeBuilder.class;
        synchronized (MerkleTreeBuilder.class) {
            for (int i = 0; i < count; ++i) {
                long readLimit = Math.min(readOffset + 0x400000L, size);
                int readSize = (int)(readLimit - readOffset);
                int fullChunkSize = (int)MerkleTreeBuilder.getFullChunkSize(readSize, 4096L, 4096L);
                ByteBuffer byteBuffer = ByteBuffer.allocate(fullChunkSize);
                int readDataLen = this.readIs(inputStream, byteBuffer, readSize);
                if (readDataLen != readSize) {
                    throw new IOException(CodeSignErrMsg.READ_INPUT_STREAM_ERROR.toString());
                }
                byteBuffer.flip();
                int readChunkIndex = (int)MerkleTreeBuilder.getFullChunkSize(0x400000L, 4096L, i);
                this.runHashTask(hashes, tasks, byteBuffer, readChunkIndex);
                readOffset += (long)readSize;
            }
            // ** MonitorExit[var11_9] (shouldn't be in output)
            tasks.arriveAndAwaitAdvance();
            for (Object hash : (Class<MerkleTreeBuilder>)hashes) {
                outputBuffer.put((byte[])hash, 0, ((Object)hash).length);
            }
            return;
        }
    }

    private int readIs(InputStream inputStream, ByteBuffer byteBuffer, int readSize) throws IOException {
        int num;
        byte[] buffer = new byte[4096];
        int readDataLen = 0;
        int len = 4096;
        while ((num = inputStream.read(buffer, 0, len)) > 0) {
            byteBuffer.put(buffer, 0, num);
            len = Math.min(4096, readSize - (readDataLen += num));
            if (len > 0 && readDataLen != readSize) continue;
            break;
        }
        return readDataLen;
    }

    private static ByteBuffer slice(ByteBuffer buffer, int begin, int end) {
        ByteBuffer tempBuffer = buffer.duplicate();
        tempBuffer.position(0);
        tempBuffer.limit(end);
        tempBuffer.position(begin);
        return tempBuffer.slice();
    }

    private static int[] getOffsetArrays(long dataSize, int digestSize) {
        ArrayList<Long> levelSize = MerkleTreeBuilder.getLevelSize(dataSize, digestSize);
        int[] levelOffset = new int[levelSize.size() + 1];
        levelOffset[0] = 0;
        for (int i = 0; i < levelSize.size(); ++i) {
            levelOffset[i + 1] = levelOffset[i] + Math.toIntExact(levelSize.get(levelSize.size() - i - 1));
        }
        return levelOffset;
    }

    private static ArrayList<Long> getLevelSize(long dataSize, int digestSize) {
        ArrayList<Long> levelSize = new ArrayList<Long>();
        long fullChunkSize = 0L;
        long originalDataSize = dataSize;
        do {
            fullChunkSize = MerkleTreeBuilder.getFullChunkSize(originalDataSize, 4096L, digestSize);
            long size = MerkleTreeBuilder.getFullChunkSize(fullChunkSize, 4096L, 4096L);
            levelSize.add(size);
            originalDataSize = fullChunkSize;
        } while (fullChunkSize > 4096L);
        return levelSize;
    }

    private void runHashTask(byte[][] hashes, Phaser tasks, ByteBuffer buffer, int readChunkIndex) {
        Runnable task = () -> {
            int bufferSize = buffer.capacity();
            int index = readChunkIndex;
            for (int offset = 0; offset < bufferSize; offset += 4096) {
                ByteBuffer chunk = MerkleTreeBuilder.slice(buffer, offset, offset + 4096);
                byte[] tempByte = new byte[4096];
                chunk.get(tempByte);
                try {
                    hashes[index++] = DigestUtils.computeDigest(tempByte, this.mAlgorithm);
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(CodeSignErrMsg.ALGORITHM_NOT_SUPPORT_ERROR.toString(this.mAlgorithm), e);
                }
            }
            tasks.arriveAndDeregister();
        };
        tasks.register();
        this.mPools.execute(task);
    }

    private void transInputDataToHashData(ByteBuffer inputBuffer, ByteBuffer outputBuffer) {
        int readSize;
        long size = inputBuffer.capacity();
        int chunks = (int)MerkleTreeBuilder.getChunkCount(size, 4096L);
        byte[][] hashes = new byte[chunks][];
        Phaser tasks = new Phaser(1);
        int startChunkIndex = 0;
        for (long readOffset = 0L; readOffset < size; readOffset += (long)readSize) {
            long readLimit = Math.min(readOffset + 0x400000L, size);
            ByteBuffer buffer = MerkleTreeBuilder.slice(inputBuffer, (int)readOffset, (int)readLimit);
            buffer.rewind();
            int readChunkIndex = startChunkIndex;
            this.runHashTask(hashes, tasks, buffer, readChunkIndex);
            readSize = (int)(readLimit - readOffset);
            startChunkIndex += (int)MerkleTreeBuilder.getChunkCount(readSize, 4096L);
        }
        tasks.arriveAndAwaitAdvance();
        for (byte[] hash : hashes) {
            outputBuffer.put(hash, 0, hash.length);
        }
    }

    public MerkleTree generateMerkleTree(InputStream inputStream, long size, FsVerityHashAlgorithm fsVerityHashAlgorithm) throws IOException, NoSuchAlgorithmException {
        this.setAlgorithm(fsVerityHashAlgorithm.getHashAlgorithm());
        int digestSize = fsVerityHashAlgorithm.getOutputByteSize();
        int[] offsetArrays = MerkleTreeBuilder.getOffsetArrays(size, digestSize);
        ByteBuffer allHashBuffer = ByteBuffer.allocate(offsetArrays[offsetArrays.length - 1]);
        this.generateHashDataByInputData(inputStream, size, allHashBuffer, offsetArrays, digestSize);
        this.generateHashDataByHashData(allHashBuffer, offsetArrays, digestSize);
        return this.getMerkleTree(allHashBuffer, size, fsVerityHashAlgorithm);
    }

    private void generateHashDataByInputData(InputStream inputStream, long size, ByteBuffer outputBuffer, int[] offsetArrays, int digestSize) throws IOException {
        int inputDataOffsetBegin = offsetArrays[offsetArrays.length - 2];
        int inputDataOffsetEnd = offsetArrays[offsetArrays.length - 1];
        ByteBuffer hashBuffer = MerkleTreeBuilder.slice(outputBuffer, inputDataOffsetBegin, inputDataOffsetEnd);
        this.transInputStreamToHashData(inputStream, size, hashBuffer);
        this.dataRoundupChunkSize(hashBuffer, size, digestSize);
    }

    private void generateHashDataByHashData(ByteBuffer buffer, int[] offsetArrays, int digestSize) {
        for (int i = offsetArrays.length - 3; i >= 0; --i) {
            ByteBuffer generateHashBuffer = MerkleTreeBuilder.slice(buffer, offsetArrays[i], offsetArrays[i + 1]);
            ByteBuffer originalHashBuffer = MerkleTreeBuilder.slice(buffer.asReadOnlyBuffer(), offsetArrays[i + 1], offsetArrays[i + 2]);
            this.transInputDataToHashData(originalHashBuffer, generateHashBuffer);
            this.dataRoundupChunkSize(generateHashBuffer, originalHashBuffer.capacity(), digestSize);
        }
    }

    private MerkleTree getMerkleTree(ByteBuffer dataBuffer, long inputDataSize, FsVerityHashAlgorithm fsVerityHashAlgorithm) throws NoSuchAlgorithmException {
        int digestSize = fsVerityHashAlgorithm.getOutputByteSize();
        dataBuffer.flip();
        byte[] rootHash = null;
        byte[] tree = null;
        if (inputDataSize <= 4096L) {
            ByteBuffer fsVerityHashPageBuffer = MerkleTreeBuilder.slice(dataBuffer, 0, digestSize);
            rootHash = new byte[digestSize];
            fsVerityHashPageBuffer.get(rootHash);
        } else {
            tree = dataBuffer.array();
            ByteBuffer fsVerityHashPageBuffer = MerkleTreeBuilder.slice(dataBuffer.asReadOnlyBuffer(), 0, 4096);
            byte[] fsVerityHashPage = new byte[4096];
            fsVerityHashPageBuffer.get(fsVerityHashPage);
            rootHash = DigestUtils.computeDigest(fsVerityHashPage, this.mAlgorithm);
        }
        return new MerkleTree(rootHash, tree, fsVerityHashAlgorithm);
    }

    private void dataRoundupChunkSize(ByteBuffer data, long originalDataSize, int digestSize) {
        long fullChunkSize = MerkleTreeBuilder.getFullChunkSize(originalDataSize, 4096L, digestSize);
        int diffValue = (int)(fullChunkSize % 4096L);
        if (diffValue > 0) {
            byte[] padding = new byte[4096 - diffValue];
            data.put(padding, 0, padding.length);
        }
    }

    private static long getChunkCount(long dataSize, long divisor) {
        return (long)Math.ceil((double)dataSize / (double)divisor);
    }

    private static long getFullChunkSize(long dataSize, long divisor, long multiplier) {
        return MerkleTreeBuilder.getChunkCount(dataSize, divisor) * multiplier;
    }
}

