/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.elf;

import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.exception.ElfFormatException;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ElfProgramHeader {
    private int pType;
    private int pFlags;
    private long pOffset;
    private long pVaddr;
    private long pPaddr;
    private long pFilesz;
    private long pMemsz;
    private long pAlign;

    public ElfProgramHeader(InputStream is, byte eiClass, byte eiData) throws IOException, ElfFormatException {
        ByteOrder bo = ByteOrder.LITTLE_ENDIAN;
        if (eiData == 1) {
            bo = ByteOrder.LITTLE_ENDIAN;
        } else if (eiData == 2) {
            bo = ByteOrder.BIG_ENDIAN;
        } else {
            throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("ei_data"));
        }
        if (eiClass == 1) {
            byte[] bytes = new byte[32];
            int read = is.read(bytes);
            if (read != 32) {
                throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("program header"));
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(bo);
            this.pType = byteBuffer.getInt();
            this.pOffset = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
            this.pVaddr = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
            this.pPaddr = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
            this.pFilesz = byteBuffer.getInt();
            this.pMemsz = byteBuffer.getInt();
            this.pFlags = byteBuffer.getInt();
            this.pAlign = byteBuffer.getInt();
        } else {
            byte[] bytes = new byte[56];
            int read = is.read(bytes);
            if (read != 56) {
                throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("program header"));
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(bo);
            this.pType = byteBuffer.getInt();
            this.pFlags = byteBuffer.getInt();
            this.pOffset = byteBuffer.getLong();
            this.pVaddr = byteBuffer.getLong();
            this.pPaddr = byteBuffer.getLong();
            this.pFilesz = byteBuffer.getLong();
            this.pMemsz = byteBuffer.getLong();
            this.pAlign = byteBuffer.getLong();
        }
    }

    public int getPFlags() {
        return this.pFlags;
    }

    public long getPOffset() {
        return this.pOffset;
    }

    public long getPFilesz() {
        return this.pFilesz;
    }
}

