/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.CodeSignBlockHeader;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class SegmentHeader {
    public static final int SEGMENT_HEADER_LENGTH = 12;
    public static final int CSB_FSVERITY_INFO_SEG = 1;
    public static final int CSB_HAP_META_SEG = 2;
    public static final int CSB_NATIVE_LIB_INFO_SEG = 3;
    private final int type;
    private int segmentOffset;
    private final int segmentSize;

    public SegmentHeader(int type, int segmentSize) {
        this(type, 0, segmentSize);
    }

    public SegmentHeader(int type, int segmentOffset, int segmentSize) {
        this.type = type;
        this.segmentOffset = segmentOffset;
        this.segmentSize = segmentSize;
    }

    public int getType() {
        return this.type;
    }

    public void setSegmentOffset(int offset) {
        this.segmentOffset = offset;
    }

    public int getSegmentOffset() {
        return this.segmentOffset;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.type);
        bf.putInt(this.segmentOffset);
        bf.putInt(this.segmentSize);
        return bf.array();
    }

    public static SegmentHeader fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        if (bytes.length != 12) {
            throw new VerifyCodeSignException("Invalid size of SegmentHeader");
        }
        ByteBuffer bf = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inType = bf.getInt();
        if (inType != 1 && inType != 2 && inType != 3) {
            throw new VerifyCodeSignException("Invalid type of SegmentHeader");
        }
        int inSegmentOffset = bf.getInt();
        if (inSegmentOffset < CodeSignBlockHeader.size()) {
            throw new VerifyCodeSignException("Invalid segmentOffset of SegmentHeader");
        }
        int inSegmentSize = bf.getInt();
        if (inSegmentSize < 0) {
            throw new VerifyCodeSignException("Invalid segmentSize of SegmentHeader");
        }
        if (inType == 1 && inSegmentSize != 64) {
            throw new VerifyCodeSignException("Invalid segmentSize of fs-verity SegmentHeader");
        }
        return new SegmentHeader(inType, inSegmentOffset, inSegmentSize);
    }

    public String toString() {
        return String.format(Locale.ROOT, "Segment Header: type=%d, seg_offset = %d, seg_size = %d", this.type, this.segmentOffset, this.segmentSize);
    }
}

