/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.Extension;
import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.exception.PageInfoException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.utils.NumberUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class PageInfoExtension
extends Extension {
    public static final int PAGE_INFO_INLINED = 2;
    public static final int PAGE_INFO_EXTENSION_DATA_SIZE_WITHOUT_SIGN = 24;
    public static final int DEFAULT_UNIT_SIZE = 4;
    private static final int RESERVED_SIZE = 3;
    private static final int SIGNATURE_ALIGNMENT = 4;
    private long mapOffset;
    private long mapSize;
    private byte unitSize;
    private byte[] reserved = new byte[3];
    private int signSize;
    private byte[] signature = new byte[0];
    private byte[] zeroPadding = new byte[0];

    public PageInfoExtension(long mapOffset, long mapSize) {
        super(2, 24);
        this.mapOffset = mapOffset;
        this.mapSize = mapSize;
        this.unitSize = (byte)4;
    }

    public void setSignature(byte[] signature) {
        if (signature != null) {
            this.signSize = signature.length;
            this.signature = signature;
            this.zeroPadding = new byte[(4 - this.signSize % 4) % 4];
        }
        super.setSize(this.size() - 8);
    }

    public long getMapOffset() {
        return this.mapOffset;
    }

    public long getMapSize() {
        return this.mapSize;
    }

    public byte getUnitSize() {
        return this.unitSize;
    }

    @Override
    public int size() {
        return 32 + this.signSize + this.zeroPadding.length;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(super.toByteArray());
        bf.putLong(this.mapOffset);
        bf.putLong(this.mapSize);
        bf.put(this.unitSize);
        bf.put(this.reserved);
        bf.putInt(this.signSize);
        bf.put(this.signature);
        bf.put(this.zeroPadding);
        return bf.array();
    }

    public static PageInfoExtension fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        byte inUnitSize;
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        long inMapOffset = bf.getLong();
        if (!NumberUtils.isMultiple4K(inMapOffset)) {
            throw new VerifyCodeSignException("mapOffset is not a multiple of 4096");
        }
        long inMapSize = bf.getLong();
        if (inMapSize % (long)(inUnitSize = bf.get()) != 0L) {
            throw new VerifyCodeSignException("mapSize is not a multiple of unitSize");
        }
        bf.get(new byte[3]);
        int inSignSize = bf.getInt();
        byte[] inSignature = new byte[inSignSize];
        bf.get(inSignature);
        PageInfoExtension extension = new PageInfoExtension(inMapOffset, inMapSize);
        extension.unitSize = inUnitSize;
        extension.setSignature(inSignature);
        return extension;
    }

    public static boolean valid(PageInfoExtension pgExtension, long dataSize) throws PageInfoException {
        if (!NumberUtils.isMultiple4K(pgExtension.getMapOffset())) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Invalid bitmapOff { " + pgExtension.getMapOffset() + " }, not a multiple of 4096"));
        }
        if (pgExtension.getUnitSize() != 4) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Invalid page info unitSize : " + pgExtension.getUnitSize()));
        }
        if (pgExtension.getMapOffset() < 0L || pgExtension.getMapSize() < 0L) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Page info offset or size is negative number"));
        }
        if (pgExtension.getMapSize() % (long)pgExtension.getUnitSize() != 0L) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Page info size is not multiple of unit"));
        }
        if (pgExtension.getMapOffset() > dataSize - pgExtension.getMapSize() / 8L) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Page info is out of dataSize"));
        }
        if (pgExtension.getMapSize() / (long)pgExtension.getUnitSize() >= dataSize / 4096L) {
            throw new PageInfoException(CodeSignErrMsg.PAGE_INFO_ERROR.toString("Page info size is not less than data page "));
        }
        return true;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "PageInfoExtension: size[%d], mapOffset[%d], mapSize[%d], unitSize[%d], signSize[%d]", this.size(), this.mapOffset, this.mapSize, this.unitSize, this.signSize);
    }
}

