/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptor;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptorWithSign;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ElfSignBlock {
    public static final int PAGE_SIZE_4K = 4096;
    public static final int MERKLE_TREE_INLINED = 2;
    private int type = 2;
    private int treeLength;
    private byte[] merkleTreeWithPadding;
    private FsVerityDescriptorWithSign descriptorWithSign;

    public ElfSignBlock(int paddingSize, byte[] merkleTreeData, FsVerityDescriptorWithSign descriptorWithSign) {
        byte[] inMerkleTreeData = new byte[]{};
        if (merkleTreeData != null) {
            inMerkleTreeData = merkleTreeData;
        }
        this.treeLength = paddingSize + inMerkleTreeData.length;
        this.merkleTreeWithPadding = new byte[this.treeLength];
        System.arraycopy(inMerkleTreeData, 0, this.merkleTreeWithPadding, paddingSize, inMerkleTreeData.length);
        this.descriptorWithSign = descriptorWithSign;
    }

    private ElfSignBlock(int type, int treeLength, byte[] merkleTreeWithPadding, FsVerityDescriptorWithSign descriptorWithSign) {
        this.type = type;
        this.treeLength = treeLength;
        this.merkleTreeWithPadding = merkleTreeWithPadding;
        this.descriptorWithSign = descriptorWithSign;
    }

    public int size() {
        return 8 + this.merkleTreeWithPadding.length + this.descriptorWithSign.size();
    }

    public static int computeMerkleTreePaddingLength(long signBlockOffset) {
        return (int)(4096L - (signBlockOffset + 8L) % 4096L) % 4096;
    }

    public byte[] getMerkleTreeWithPadding() {
        return this.merkleTreeWithPadding;
    }

    public long getDataSize() {
        return this.descriptorWithSign.getFsVerityDescriptor().getFileSize();
    }

    public long getTreeOffset() {
        return this.descriptorWithSign.getFsVerityDescriptor().getMerkleTreeOffset();
    }

    public byte[] getSignature() {
        return this.descriptorWithSign.getSignature();
    }

    public byte[] toByteArray() throws FsVerityDigestException {
        ByteBuffer bf = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.type);
        bf.putInt(this.merkleTreeWithPadding.length);
        bf.put(this.merkleTreeWithPadding);
        bf.put(this.descriptorWithSign.toByteArray());
        return bf.array();
    }

    public static ElfSignBlock fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inTreeType = bf.getInt();
        if (2 != inTreeType) {
            throw new VerifyCodeSignException("Invalid merkle tree type of ElfSignBlock");
        }
        int inTreeLength = bf.getInt();
        byte[] treeWithPadding = new byte[inTreeLength];
        bf.get(treeWithPadding);
        int inFsdType = bf.getInt();
        if (1 != inFsdType) {
            throw new VerifyCodeSignException("Invalid fs-verify descriptor type of ElfSignBlock");
        }
        int inFsdLength = bf.getInt();
        if (bytes.length != 8 + inTreeLength + 8 + inFsdLength) {
            throw new VerifyCodeSignException("Invalid fs-verify descriptor with signature length of ElfSignBlock");
        }
        byte[] fsdArray = new byte[256];
        bf.get(fsdArray);
        FsVerityDescriptor fsd = FsVerityDescriptor.fromByteArray(fsdArray);
        if (inFsdLength != fsd.getSignSize() + 256) {
            throw new VerifyCodeSignException("Invalid sign size of ElfSignBlock");
        }
        byte[] inSignature = new byte[inFsdLength - 256];
        bf.get(inSignature);
        FsVerityDescriptorWithSign fsVerityDescriptorWithSign = new FsVerityDescriptorWithSign(inFsdType, inFsdLength, fsd, inSignature);
        return new ElfSignBlock(inTreeType, inTreeLength, treeWithPadding, fsVerityDescriptorWithSign);
    }
}

