/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;

public class CodeSignBlockHeader {
    public static final int FLAG_MERKLE_TREE_INLINED = 1;
    public static final int FLAG_NATIVE_LIB_INCLUDED = 2;
    private static final int CODE_SIGNING_VERSION = 1;
    private static final byte MAGIC_BYTE_ARRAY_LENGTH = 8;
    private static final long MAGIC_NUM = -2285919006713316147L;
    private static final byte RESERVED_BYTE_ARRAY_LENGTH = 8;
    private static final int SEGMENT_NUM = 3;
    private long magic;
    private int version;
    private int blockSize;
    private int segmentNum;
    private int flags;
    private byte[] reserved;

    private CodeSignBlockHeader(Builder builder) {
        this.magic = builder.magic;
        this.version = builder.version;
        this.blockSize = builder.blockSize;
        this.segmentNum = builder.segmentNum;
        this.flags = builder.flags;
        this.reserved = builder.reserved;
    }

    public void setSegmentNum(int num) {
        this.segmentNum = num;
    }

    public int getSegmentNum() {
        return this.segmentNum;
    }

    public void setBlockSize(long size) {
        this.blockSize = (int)size;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(CodeSignBlockHeader.size()).order(ByteOrder.LITTLE_ENDIAN);
        bf.putLong(this.magic);
        bf.putInt(this.version);
        bf.putInt(this.blockSize);
        bf.putInt(this.segmentNum);
        bf.putInt(this.flags);
        bf.put(this.reserved);
        return bf.array();
    }

    public static CodeSignBlockHeader fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        if (bytes.length != CodeSignBlockHeader.size()) {
            throw new VerifyCodeSignException("Invalid size of CodeSignBlockHeader");
        }
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        long inMagic = bf.getLong();
        if (inMagic != -2285919006713316147L) {
            throw new VerifyCodeSignException("Invalid magic num of CodeSignBlockHeader");
        }
        int inVersion = bf.getInt();
        if (inVersion != 1) {
            throw new VerifyCodeSignException("Invalid version of CodeSignBlockHeader");
        }
        int inBlockSize = bf.getInt();
        int inSegmentNum = bf.getInt();
        if (inSegmentNum != 3) {
            throw new VerifyCodeSignException("Invalid segmentNum of CodeSignBlockHeader");
        }
        int inFlags = bf.getInt();
        if (inFlags < 0 || inFlags > 3) {
            throw new VerifyCodeSignException("Invalid flags of CodeSignBlockHeader");
        }
        byte[] inReserved = new byte[8];
        bf.get(inReserved);
        return new Builder().setMagic(inMagic).setVersion(inVersion).setBlockSize(inBlockSize).setSegmentNum(inSegmentNum).setFlags(inFlags).setReserved(inReserved).build();
    }

    public static int size() {
        return 32;
    }

    public String toString() {
        return String.format(Locale.ROOT, "CodeSignBlockHeader{magic: %d, version: %d, blockSize: %d, segmentNum: %d, flags: %d}", this.magic, this.version, this.blockSize, this.segmentNum, this.flags);
    }

    public static class Builder {
        private long magic = -2285919006713316147L;
        private int version = 1;
        private int blockSize;
        private int segmentNum;
        private int flags;
        private byte[] reserved = new byte[8];

        public Builder setMagic(long magic) {
            this.magic = magic;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder setSegmentNum(int segmentNum) {
            this.segmentNum = segmentNum;
            return this;
        }

        public Builder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder setReserved(byte[] reserved) {
            this.reserved = reserved;
            return this;
        }

        public CodeSignBlockHeader build() {
            return new CodeSignBlockHeader(this);
        }
    }
}

