---
title: "Updates for 2023-03-07"
date: 2023-03-07
summary: Various apps, CLIs, chatbots, and tools have been developed using OpenAI's GPT-3 API. These include ChatPDF, OpenCat, OpenAI Translator, i18n-cli, and LlamaIndex.
---
Here's the projects added or updated today:

## Apps

- [ChatPDF](https://www.chatpdf.com/)
    - ChatPDF is an innovative tool that allows users to verbally communicate with their PDF files, making it easier to extract information from large documents such as manuals, legal contracts, and research papers.

- [Chat with GPT](chatwithgpt.netlify.app)
    - An open source ChatGPT web UI with additional features like TTS. Source code: [cogentapps/chat-with-gpt](https://github.com/cogentapps/chat-with-gpt)

- [OpenCat](https://opencat.app/)
    - A native desktop ChatGPT client that utilizes your own API key, providing a faster and enhanced chat experience.

- [OpenAI Translator](https://translator.lance.moe/)
    - A translator app that uses OpenAI GPT-3 to translate between languages. It is a PWA that can be installed on your phone or desktop. Source code: [LanceMoe/openai-translator](https://github.com/LanceMoe/openai-translator)

- [BiliGPT](https://b.jimmylv.cn/)
    - One-click summary of the subtitled Bilibili Video. Source code: [JimmyLv/BiliGPT](https://github.com/JimmyLv/BiliGPT)

- [ResearchGPT](https://researchgpt.ue.r.appspot.com/)
    - This is a flask app provides an interface to enable a conversation with a research paper. Source code: [ResearchGPT](https://github.com/mukulpatnaik/researchgpt).
    - The author explored the utilization of vector embeddings derived from the text that closely matches the prompt in the original tweet: [@mukul0x](https://twitter.com/mukul0x/status/1625673579399446529)

- [NITM GPT](https://github.com/deskbtm/nitmgpt)
    - An Android application that filters ads, spam, notifications using GPT AI.


## CLI

- [i18n-cli](https://github.com/pandodao/i18n-cli)
    - A command-line interface (CLI) tool that utilizes the OpenAI API to translate locale files based on JSON format.

- [verdverm/chatgpt](https://github.com/verdverm/chatgpt)
    - A python package to interface with OpenAI's GPT-3 API.

- [cz-git/recipes-openai](https://cz-git.qbb.sh/recipes/openai)
    - A Commitizen CLI and Commitizen adapter generate standardized commit messages with AI.

## Chatbots

- Telegram
    - [karfly/chatgpt\_telegram\_bot](https://github.com/karfly/chatgpt_telegram_bot): Written in **Python**.
    - [n3d1117/chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot): Written in **Python**.
    - [RainEggplant/chatgpt-telegram-bot](https://github.com/RainEggplant/chatgpt-telegram-bot): Written in **JavaScript**.
    - [leafduo/chatgpt-telegram-bot](https://github.com/leafduo/chatgpt-telegram-bot): Written in **Go**.
    - [TBXark/ChatGPT-Telegram-Workers](https://github.com/TBXark/ChatGPT-Telegram-Workers): This one has been specifically made for **Cloudflare Workers**.

- WeChat
    - [zhayujie/chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat)
    - [philsong/chatgpt_wechatbot](https://github.com/philsong/chatgpt_wechatbot)

- Microsoft Teams
    - [ChatGPT-Teams-Bot](https://github.com/ashishsinghbaghel/ChatGPT-Teams-Bot)

- Slack
    - [openai-chatbot](https://github.com/david-cao/openai-chatbot)

- Feishu
    - [bestony/ChatGPT-Feishu](https://github.com/bestony/ChatGPT-Feishu)
    - [Leizhenpeng feishu-chatGpt](https://github.com/Leizhenpeng/feishu-chatGpt)
    - [go-zoox/chatgpt-for-chatbot-feishu](https://github.com/go-zoox/chatgpt-for-chatbot-feishu)
    - [key7men/openai-feishu-bot](https://github.com/key7men/openai-feishu-bot)

## Tools

- [LlamaIndex 🦙 \(GPT Index\)](https://github.com/jerryjliu/gpt_index)
    - A search engine for OpenAI's GPT models.

- [Tiktokenizer](https://tiktokenizer.z22.web.core.windows.net/)
    - Online playground for openai's tiktoken library, calculating the correct number of tokens for a given prompt. Source code: [dqbd/tiktokenizer](https://github.com/dqbd/tiktokenizer)

- [OpenAI GPT-3.5 Price Calculator](https://openai.deepakness.com/)
    - Calculate how much it will cost to generate certain number of words by using OpenAI GPT-3.5 API.

### Articles

- [How to Use OpenAI's GPT-3 API to Generate High-Quality Texts](https://towardsdatascience.com/how-to-use-openais-gpt-3-api-to-generate-high-quality-texts-in-python-2bc0b18a8a8a)
- [How to build a chatbot with GPT-3 and Node.js
