---
title: "2023-03-07 项目更新"
date: 2023-03-07
summary: 使用OpenAI的GPT-3 API已经开发了各种应用程序、CLI、聊天机器人和工具。其中包括ChatPDF、OpenCat、OpenAI翻译器、i18n-cli和LlamaIndex。
---
以下是今天添加或更新的项目：

## 应用程序

- [ChatPDF](https://www.chatpdf.com/)
    - ChatPDF 是一款创新的工具，允许用户与其 PDF 文件进行口头交流，使从大型文档（如手册、法律合同和研究论文）中提取信息更加容易。

- [Chat with GPT](chatwithgpt.netlify.app)
    - 带有 TTS 等其他功能的开源 ChatGPT web UI。源代码：[cogentapps/chat-with-gpt](https://github.com/cogentapps/chat-with-gpt)

- [OpenCat](https://opencat.app/)
    - 一款本地的 ChatGPT 客户端，利用您自己的 API 密钥，提供更快速、更出色的聊天体验。

- [OpenAI Translator](https://translator.lance.moe/)
    - 一款使用 OpenAI GPT-3 进行语言翻译的翻译应用程序。它是一款可以安装在手机或桌面上的 PWA。源代码：[LanceMoe/openai-translator](https://github.com/LanceMoe/openai-translator)

- [BiliGPT](https://b.jimmylv.cn/)
    - 点击即可总结字幕的 Bilibili 视频。源代码：[JimmyLv/BiliGPT](https://github.com/JimmyLv/BiliGPT)

- [ResearchGPT](https://researchgpt.ue.r.appspot.com/)
    - 这是一个 Flask 应用程序，提供一个接口，使研究论文可以进行对话。源代码：[ResearchGPT](https://github.com/mukulpatnaik/researchgpt)。
    - 作者探索了从文本中派生的向量嵌入的利用，这些文本与原始推文中的提示紧密匹配：[@mukul0x](https://twitter.com/mukul0x/status/1625673579399446529)

- [NITM GPT](https://github.com/deskbtm/nitmgpt)
    - 一款使用 GPT AI 过滤广告、垃圾邮件和通知的 Android 应用程序。

## CLI

- [i18n-cli](https://github.com/pandodao/i18n-cli)
    - 一款利用 OpenAI API 根据 JSON 格式的本地化文件进行翻译的命令行界面（CLI）工具。

- [verdverm/chatgpt](https://github.com/verdverm/chatgpt)
    - 一个 Python 包，用于与 OpenAI 的 GPT-3 API 进行交互。

- [cz-git/recipes-openai](https://cz-git.qbb.sh/recipes/openai)
    - 一个 Commitizen CLI 和 Commitizen 适配器，用于生成带有 AI 的标准化提交消息。

## 聊天机器人

- 电报
    - [karfly/chatgpt\_telegram\_bot](https://github.com/karfly/chatgpt_telegram_bot)：用 **Python** 编写。
    - [n3d1117/chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot)：用 **Python** 编写。
    - [RainEggplant/chatgpt-telegram-bot](https://github.com/RainEggplant/chatgpt-telegram-bot)：用 **JavaScript** 编写。
    - [leafduo/chatgpt-telegram-bot](https://github.com/leafduo/chatgpt-telegram-bot)：用 **Go** 编写。
    - [TBXark/ChatGPT-Telegram-Workers](https://github.com/TBXark/ChatGPT-Telegram-Workers)：这个特别为 **Cloudflare Workers** 制作。

- 微信
    - [zhayujie/chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat)
    - [philsong/chatgpt_wechatbot](https://github.com/philsong/chatgpt_wechatbot)

- 微软团队
    - [ChatGPT-Teams-Bot](https://github.com/ashishsinghbaghel/ChatGPT-Teams-Bot)

- Slack
    - [openai-chatbot](https://github.com/david-cao/openai-chatbot)

- 飞书
    - [bestony/ChatGPT-Feishu](https://github.com/bestony/ChatGPT-Feishu)
    - [Leizhenpeng feishu-chatGpt](https://github.com/Leizhenpeng/feishu-chatGpt)
    - [go-zoox/chatgpt-for-chatbot-feishu](https://github.com/go-zoox/chatgpt-for-chatbot-feishu)
    - [key7men/openai-feishu-bot](https://github.com/key7men/openai-feishu-bot)

## 工具

- [LlamaIndex 🦙 \(GPT Index\)](https://github.com/jerryjliu/gpt_index)
    - OpenAI 的 GPT 模型的搜索引擎。

- [Tiktokenizer](https://tiktokenizer.z22.web.core.windows.net/)
    - OpenAI 的 tiktoken 库的在线游乐场，计算给定提示的正确令牌数量。源代码：[dqbd/tiktokenizer](https://github.com/dqbd/tiktokenizer)

- [OpenAI GPT-3.5 价格计算器](https://openai.deepakness.com/)
    - 通过使用 OpenAI GPT-3.5 API 计算生成特定数量的单词所需的成本。

### 文章

- [如何使用 OpenAI 的 GPT-3 API 生成高质量的文本](https://towardsdatascience.com/how-to-use-openais-gpt-3-api-to-generate-high-quality-texts-in-python-2bc0b18a8a8a)
- [如何使用 GPT-3 和 Node.js 构建聊天机器人](https://www.twilio.com/blog/how-to-build-a-chatbot-with-gpt-3-and-node-js)
