# Awesome ChatGPT API

精心策划的应用程序和工具列表，不仅使用新的 [ChatGPT API](https://platform.openai.com/docs/api-reference/chat), 还允许用户自行配置 [API keys](https://platform.openai.com/account/api-keys), 允许免费和按需使用自己的配额。

还有一个[开发](#开发)部分，该部分为开发人员提供了一系列项目和文章，以帮助他们更好地进行构建.

请访问网站获取最新消息: [awesome-chatgpt-api.top](https://awesome-chatgpt-api.top/)

> 由 [Reorx](https://reorx.com) 收集整理，欢迎在 Twitter 或通过 PR 向我提交新的作品，但请确保您已经阅读了[提交须知](https://github.com/reorx/awesome-chatgpt-api/issues/21)。


**目录表**

- [插件和扩展](#插件和扩展)
- [Web应用](#web应用)
  - [类似chatgpt的Web-UI](#类似chatgpt的web-ui)
  - [特殊用途](#特殊用途)
- [桌面和移动应用程序](#桌面和移动应用程序)
  - [类似chatgpt的Web-UI](#类似chatgpt的web-ui)
  - [特殊用途](#特殊用途)
- [CLI](#cli)
- [聊天机器人](#聊天机器人)
- [开发](#开发)
  - [项目](#项目)
  - [工具](#工具)
  - [文章](#文章)


## 插件和扩展

- Chrome扩展

    - [ChatGPT Box](https://github.com/josStorer/chatGPTBox)

        深度ChatGPT集成在您的浏览器。支持在任何页面上随时调用聊天对话框，用右键菜单总结任何页面，独立对话页面，多个API等等。此扩展可在Chrome, Edge, Safari和Firefox上使用。

    - [Glarity](https://glarity.app/)

         总结谷歌搜索结果或YouTube视频与ChatGPT API，也支持雅虎!PubMed, PMC, NewsPicks, Github，日经，必应，谷歌专利。这个扩展还支持ChatGPT Webapp的API，不需要配置。

    - [ChatGPT Sidebar](https://chatgpt-sidebar.com/)

        在任何网页中打开侧边栏，向ChatGPT询问有关页面内容的任何信息。比如解释、翻译、总结或重写。您可以自定义提示以方便访问。这个扩展还支持ChatGPT Webapp的API，不需要配置。

    - [ChatHub](https://chrome.google.com/webstore/detail/chathub-all-in-one-chatbo/iaakpnchhognanibcahlpcplchdfmgma)

        ChatHub是一个一体化聊天机器人客户端，目前支持ChatGPT和新的必应聊天。它允许同时与多个聊天机器人聊天，便于比较它们的答案。源代码:[chathub-dev/chathub](https://github.com/chathub-dev/chathub)

    - [TeamSmart AI](https://www.teamsmart.ai/)

        TeamSmart AI是一款Chrome浏览器扩展，旨在提高您的生产力并增强您的ChatGPT体验。它允许你组建一个人工智能助手团队来帮助你完成日常任务。它可以与您自己的OpenAI API密钥一起使用。

    - [OpenAI Translator](https://github.com/yetone/openai-translator)

        一个Chrome扩展，使用OpenAI API翻译文本，附加功能，如抛光和总结。

    - [ChatGPT » summarize everything!](https://chrome.google.com/webstore/detail/chatgpt-%C2%BB-summarize-every/cbgecfllfhmmnknmamkejadjmnmpfjmp)

        一个Chrome扩展，总结任何网站与ChatGPT。
        其他功能包括总结任何Youtube视频的成绩单和自定义模板。这个扩展还支持ChatGPT Webapp的API，不需要配置。

- [Emacs](https://www.gnu.org/software/emacs/) Packages

    - [GPTel](https://github.com/karthink/gptel)
    
        在Emacs中添加一个主模式，其作用类似于ChatGPT网页。它支持多个聊天会话，可以将任何文本选择发送到ChatGPT API，以获得答案，校对，代码建议等。
        
    - [org-ai](https://github.com/rksm/org-ai) 
    
        在Emacs笔记包org模式中添加一个块，该块可以与ChatGPT聊天并使用dll - e生成图像。它支持语音到文本的输入和文本到语音的读出。

- [Obsidian](https://obsidian.md/) Plugins

    - [Obsidian Text Generator Plugin](https://github.com/nhaouari/obsidian-textgenerator-plugin)

        根据你的黑曜石笔记产生想法、吸引人的标题、摘要、大纲和整个段落。

- [Logseq](https://logseq.com/) Plugins

    - [Logseq Plugin GPT3 OpenAI](https://github.com/briansunter/logseq-plugin-gpt3-openai)

        一个插件使用GPT-3 AI辅助笔记在Logseq。

- [Roam Research](https://roamresearch.com/) Plugins

    - [roam-ai](https://github.com/LayBacc/roam-ai)

        基于当前块生成文本;使用dall-e2生成图像;改述

- [Popclip](https://pilotmoon.com/popclip/) Extensions

    - [ChatGPT — PopClip Extensions](https://pilotmoon.com/popclip/extensions/page/ChatGPT)

        将选定的文本发送到ChatGPT并附加响应。

    - [ChatGPT Proofreader extension for Popclip](https://reorx.com/makers-daily/003-chatgpt-proofreader-extension-popclip/)

        校对选定的文本，并附上增强的结果。

    - [ChatGPT Grammar Check PopClip Extension](https://github.com/hirakujira/ChatGPT-Grammar-Check-PopClip-Extension)

        类似于ChatGPT校对扩展，具有不同的提示符和可下载的包。

- [Drafts](https://getdrafts.com/) Actions

    - [ChatGPT Conversation | Drafts Directory](https://directory.getdrafts.com/a/2HJ)

        在草稿笔记中与ChatGPT进行对话，新的回复将在最后添加。支持声明和修改系统、助手和用户角色消息块。

- [Bob](https://bobtranslate.com/) Plugins

    - [OpenAI Translator Bob Plugin](https://github.com/yetone/bob-plugin-openai-translator)

        基于ChatGPT API的Bob插件，用于文本翻译、文本细化和语法纠正。它有一个派生版本，特别强调校对的任务： [OpenAI Polisher Bob Plugin](https://github.com/yetone/bob-plugin-openai-polisher).

- 苹果快捷键

    - [ChatGPT Siri](https://github.com/Yue-Yang/ChatGPT-Siri)

        快捷键Siri连接ChatGPT 3.5涡轮模型，支持连续对话

    - [Siri Pro](https://www.icloud.com/shortcuts/6889d862918e479693be11fd9a0293b2)

      一个增强的快捷方式基于 **ChatGPT Siri**. 原文: [@DottChen](https://twitter.com/DottChen/status/1631309329684123650)

    - [Share to ChatGPT](https://github.com/reorx/Share-to-ChatGPT-Shortcut)

       分享到ChatGPT是一个苹果快捷方式，允许用户分享突出显示的文本到ChatGPT，同时还包括个性化的提示，响应消息将自动复制到用户的剪贴板。

- [Keyboard Maestro](https://www.keyboardmaestro.com/) Macros

    - [Copy to Ask ChatGPT](https://blog.retompi.com/post/use-chatgpt-api/#keyboard-maestro)

        选择并复制文本以使用键盘快捷键询问ChatGPT. [下载链接](https://p15.p3.n0.cdn.getcloudapp.com/items/geuEZvwA/aeed10cb-a35d-404f-a17f-da1d46c9c9c7.kmmacros)

    - [我的六個專屬 ChatGPT 助手](https://pinchlime.com/newsletters/my-six-chatgpt-assistants/)

- GitHub App

    - [CR.GPT](https://github.com/apps/cr-gpt)

        由ChatGPT驱动的代码审查机器人

- [LaunchBar](https://www.obdev.at/products/launchbar/) Actions

    - [ChipiChat](https://github.com/quinncomendant/ChipiChat.lbaction)

        与ChatGPT API交互的LaunchBar操作。响应直接在LaunchBar中接收，可以通过Quick Look浏览、打开、预览、插入或发送到另一个操作。保存会话历史记录以供参考。ChatGPT系统消息可以通过角色进行配置。


## web应用


### 类似chatgpt的web-ui

- [ChatKit](https://chatkit.app/)

    一个轻量级的ChatGPT Web UI，允许设置url作为对话的上下文。

- [TypingMind](https://www.typingmind.com/)

    一个更好的用户界面ChatGPT，与增强的功能，如快速响应，聊天搜索，集成，提示库等。

- [ChatGPT Next Web](https://github.com/Yidadaa/ChatGPT-Next-Web)<img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    一键部署设计良好的ChatGPT web UI在Vercel。界面经过抛光，支持响应式设计、暗模式和PWA。具有内置提示库，对话压缩和将聊天记录导出为Markdown文件等功能。

- [Chatbot UI](https://github.com/mckaywrigley/chatbot-ui) <img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    Chatbot UI是OpenAI聊天模型的高级聊天机器人套件，基于Chatbot UI Lite，使用Next.js、TypeScript和顺风CSS。

- [Chat with GPT](https://chatwithgpt.netlify.app) <img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    一个开源的ChatGPT web UI与附加功能，如TTS。源代码: [cogentapps/chat-with-gpt](https://github.com/cogentapps/chat-with-gpt)

- [ChatGPT Web](https://github.com/Chanzhaoyu/chatgpt-web) <img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    一个使用ve3和Express构建的ChatGPT web应用程序演示。

- [Next.js ChatGPT](https://github.com/enricoros/nextjs-chatgpt-app) <img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    这是一个使用Next.js和TypeScript构建的响应式聊天web应用程序，由OpenAI的GPT-4提供支持，具有聊天流，代码高亮显示，代码执行，开发预设等功能。

- [ChatGPT-API Demo](https://github.com/ddiu8081/chatgpt-demo) <img src="https://img.shields.io/badge/-self--hosted-1adc61" />

    一个用Astro和TypeScript构建的ChatGPT web应用演示。

    相关项目: [ChatGPT-Vercel](https://github.com/ourongxing/chatgpt-vercel) is another ChatGPT web app based on ddiu8081/chatgpt-demo, specifically made for deploying on Vercel.


### 特殊用途

- [ChatFiles](https://github.com/guangzhengli/ChatFiles)

    一个可以上传文件并与之对话的网络应用程序。
    该存储库使用jerryjliu/llama_index拆分大文本，基于mckaywrigley/chatbot-ui，并受到madawei2699/myGPTReader的启发

- [ChatPDF](https://www.chatpdf.com/)

    ChatPDF是一种创新的工具，它允许用户与他们的PDF文件进行口头交流，从而更容易从手册、法律合同和研究论文等大型文档中提取信息。

- [OpenAI Translator](https://translator.lance.moe/)

    一款使用OpenAI GPT-3进行语言翻译的翻译应用程序。它是一个PWA，可以安装在您的手机或桌面上。源代码: [LanceMoe/openai-translator](https://github.com/LanceMoe/openai-translator)

- [BiliGPT](https://b.jimmylv.cn/)

    哔哩哔哩字幕视频一键汇总。源代码: [JimmyLv/BiliGPT](https://github.com/JimmyLv/BiliGPT)

- [ResearchGPT](https://researchgpt.ue.r.appspot.com/)

    这是一个flask应用程序，提供了一个界面，可以与研究论文进行对话。
    源代码: [mukulpatnaik/ResearchGPT](https://github.com/mukulpatnaik/researchgpt).

    作者探索了从与原始tweet中的提示密切匹配的文本中派生的向量嵌入的利用： [@mukul0x](https://twitter.com/mukul0x/status/1625673579399446529)

- [ChatGPT Academic](https://github.com/binary-husky/chatgpt_academic)

    专门针对科研工作的ChatGPT应用，针对学术论文校对体验进行优化，支持自定义快捷按钮，支持降价表显示，Tex公式双显示，改进代码显示功能，增加本地Python项目分析/自分析功能。

- [AI Subtitle Translator](https://ai.cgsv.top/)

    使用GPT-3.5 API翻译本地或Youtube/Bilibili字幕。源代码: [AI Subtitle](https://github.com/cgsvv/AISubtitle)

- [Visual ChatGPT](https://github.com/microsoft/visual-chatgpt)
    
    Visual ChatGPT是一个web应用程序，它将ChatGPT和一系列Visual Foundation Models连接起来，以便在聊天过程中发送和接收图像。


## 桌面和移动应用程序


### 类似chatgpt的web-ui

- [ChatBox](https://github.com/Bin-Huang/chatbox)

    ChatBox是OpenAI API的跨平台桌面客户端，也是一个即时调试和管理工具。

- [OpenCat](https://opencat.app/)

    本机桌面ChatGPT客户端，利用您自己的API密钥，提供更快和增强的聊天体验。

- [MacGPT](https://www.macgpt.com/)

    一个本地桌面ChatGPT应用程序，与功能，如访问ChatGPT从任何地方在您的Mac与全局，把ChatGPT直接到您的文本字段与MacGPT内联，并快速访问ChatGPT从您的菜单栏。

- [AssisChat](https://assischat.com)

    一个在iOS上运行的ChatGPT API客户端。它可以用来翻译和润色文本，而无需离开其他应用程序，利用系统的共享功能。

- [OpenChit](https://apps.apple.com/cn/app/openchit/id6446192123)

    一个在iOS上运行的ChatGPT API客户端。有语音输入和TTS等功能。

- [MindMac](https://mindmac.app)

    毫不费力地管理您的聊天和文件夹，同时监控成本与直观的macOS应用程序，由ChatGPT API供电，并设计为最大的生产力。内置提示模板，支持GPT-3.5和GPT-4。

### Special-purpose

- [ChatGPT Translator](https://github.com/simpleapples/chatgpt-translator)

    ChatGPT Translator是一个开源的桌面应用程序，允许您使用GPT语言模型翻译文本。

- [OpenAI Translator](https://github.com/yetone/openai-translator)

    基于ChatGPT API的浏览器扩展和跨平台桌面翻译应用程序。
    
- [Polyglot](https://github.com/liou666/polyglot) 

    基于ChatGPT API和Azure TTS的桌面AI语言实践应用

- [NITM GPT](https://github.com/deskbtm/nitmgpt)

    一个Android应用程序，过滤广告，垃圾邮件，通知使用GPT AI。

- [CommuniqAI](https://play.google.com/store/apps/details?id=dev.mtc.ga)

    这是一个Android应用程序，通过调度和自动发送SMS文本消息(以及电话和电子邮件)来帮助您保持联系，同时利用ChatGPT生成消息。


## CLI

- [ShellGPT](https://github.com/TheR1D/shell_gpt)

    一个由ChatGPT提供支持的命令行生产力工具。功能包括生成shell命令、代码片段、注释和文档。

- [bilingual\_book\_maker](https://github.com/yihong0618/bilingual_book_maker)

    使用AI翻译制作双语电子书。原创推文 [@yihong0618](https://twitter.com/yihong0618/status/1630948132564631552)

    在[streamlit](https://goldengrape-bilingual-book-maker-streamlit-app-x7nhof.streamlit.app/)上有一个web UI，由[tweet](https://twitter.com/goldengrape/status/1631549869306572800)的作者制作。

- [AI Commits](https://github.com/Nutlope/aicommits)

    一个用AI为你写git提交消息的CLI。

- [cz-git](https://github.com/Zhengqbbb/cz-git)

    commizen CLI和commizen适配器使用AI生成标准化的提交消息。 [Recipes/OpenAI](https://cz-git.qbb.sh/recipes/openai)

- [turbocommit](https://github.com/Sett17/turboCommit)

    使用阶段性diff和可选消息创建常规提交的CLI。

- [xiaogpt](https://github.com/yihong0618/xiaogpt)

    与小米AI扬声器一起玩ChatGPT。

- [AI Vocabulary Builder](https://github.com/piglei/ai-vocabulary-builder)

   帮助您使用AI构建词汇表的CLI。

- [verdverm/chatgpt](https://github.com/verdverm/chatgpt)

    用于与ChatGPT API交互或在基于文件的会话中工作的CLI应用程序。支持提示工程和大多数配置。

- [ai-cli](https://github.com/yufeikang/ai-cli)

    该命令行工具允许您在命令行中轻松使用chatGPT。你可以和它聊天，向它提问，并获得文本翻译。它还支持在终端中呈现Markdown。

- [chatgpt-cli](https://github.com/efJerryYang/chatgpt-cli/)

    一个支持markdown的命令行接口工具，使用OpenAI的API密钥连接到ChatGPT。所提供的命令使您能够像使用官方web客户端一样使用此工具。对话以JSON格式保存在您的机器中。

- [chatGPT-shell-cli](https://github.com/0xacx/chatGPT-shell-cli)

    一个简单的，轻量级的shell脚本，从终端使用OpenAI的chatGPT和dll - e。

- [i18n-cli](https://github.com/pandodao/i18n-cli)

   一个命令行接口(CLI)工具，它利用OpenAI API来翻译基于JSON格式的语言环境文件。

- [ChatGPT-for-Translation](https://github.com/Raychanan/ChatGPT-for-Translation)

    翻译文本文件的Python工具。它提供双语翻译、多线程和自动处理过多的请求频率。

- [subtitle-translator](https://github.com/gnehs/subtitle-translator)

    基于ChatGPT的字幕翻译CLI工具，使用NodeJS开发。它也有一个GUI版本 [subtitle-translator-electron](https://github.com/gnehs/subtitle-translator-electron)

- [Multimedia GPT](https://github.com/fengyuli2002/multimedia-gpt)

    多媒体GPT连接OpenAI GPT与视觉和音频。用户现在可以发送图像、视频和录音，并获得文本和图像格式的回复。

- [README-AI](https://github.com/eli64s/README-AI)

   用于制作美观、结构化和信息丰富的README的命令行工具。md文件。由OpenAI语言模型API提供支持。

- [GPTerminator](https://github.com/AineeJames/ChatGPTerminator)

   GPTerminator是一个python包，它提供了一种使用命令行接口与OpenAI的聊天完成和图像生成API进行交互的方便方法。

- [naming](https://github.com/davidleitw/naming)

    naming 是一个命令行工具，它为函数和变量建议直观和描述性的名称，从而提高代码的可读性。它使用ChatGPT API生成适合您代码的程序命名建议。
    
- [AI Shell](https://github.com/BuilderIO/ai-shell)

    将自然语言转换为shell命令的CLI。受Github Copilot X CLI的启发，对所有人开放源代码。

- [DoctorGPT](https://github.com/ingyamilmolinar/doctorgpt)

    DoctorGPT将GPT引入生产环境，用于应用程序日志错误诊断。

- [aider](https://github.com/paul-gauthier/aider)

    aider是一个命令行聊天工具，允许您在终端中使用GPT-4进行编码。向GPT询问特性、改进或错误修复，aider将把建议的更改应用到源文件中。每个更改都会自动提交到git，并附带一个描述性的提交消息。
    
- [mods](https://github.com/charmbracelet/mods)

   Mods的工作原理是通过读取标准，并在Mods参数中提供提示符。可选地，它将输出格式化为Markdown，您可以通过管道将其传输到Markdown呈现cli。例如: `mods -f "what are your thoughts on improving this code?" < main.go | glow`

## 聊天机器人

- 电报
    - [karfly/chatgpt\_telegram\_bot](https://github.com/karfly/chatgpt_telegram_bot): Written in **Python**.
    - [n3d1117/chatgpt-telegram-bot](https://github.com/n3d1117/chatgpt-telegram-bot): Written in **Python**.
    - [RainEggplant/chatgpt-telegram-bot](https://github.com/RainEggplant/chatgpt-telegram-bot): Written in **JavaScript**.
    - [leafduo/chatgpt-telegram-bot](https://github.com/leafduo/chatgpt-telegram-bot): Written in **Go**.
    - [TBXark/ChatGPT-Telegram-Workers](https://github.com/TBXark/ChatGPT-Telegram-Workers): This one has been specifically made for **Cloudflare Workers**.
    - [franalgaba/chatgpt-telegram-bot-serverless](https://github.com/franalgaba/chatgpt-telegram-bot-serverless): Free and in AWS serverless bot in **Python**.
    - [iamwavecut/telegram-chatgpt-bot](https://github.com/iamwavecut/telegram-chatgpt-bot): Written in **Go** and comes with the **Dockerfile** for easy setup.
- Slack
    - [myGPTReader](https://github.com/madawei2699/myGPTReader)

        myGPTReader是一个slack机器人，可以阅读任何网页，电子书，视频(YouTube)或文档，并与chatGPT总结。它还可以使用频道中的内容通过语音与您交谈。
- 微信
    - [zhayujie/chatgpt-on-wechat](https://github.com/zhayujie/chatgpt-on-wechat)
    - [ChatGPT for Wechat](https://chatgpt4wechat.aow.me/)
- 飞书
    - [bestony/ChatGPT-Feishu](https://github.com/bestony/ChatGPT-Feishu)
    - [Leizhenpeng feishu-chatGpt](https://github.com/Leizhenpeng/feishu-chatGpt)
    - [go-zoox/chatgpt-for-chatbot-feishu](https://github.com/go-zoox/chatgpt-for-chatbot-feishu)
    - [key7men/openai-feishu-bot](https://github.com/key7men/openai-feishu-bot)
- 钉钉
    - [eryajf/chatgpt-dingtalk](https://github.com/eryajf/chatgpt-dingtalk): Written in **Go**.
- Teams
    - [formulahendry/chatgpt-teams-bot](https://github.com/formulahendry/chatgpt-teams-bot)


## 开发

### 项目

- [OpenAI Cookbook](https://github.com/openai/openai-cookbook)

    官方示例和指南使用OpenAI API，包括如何嵌入长输入，流完成，格式更好的输入和更多。
    
- [DocsGPT](https://github.com/arc53/docsgpt)

     一个开源解决方案，简化了在项目文档中查找信息的过程。通过集成强大的GPT模型，开发人员可以轻松地提出有关项目的问题并获得准确的答案。

- [Paul Graham GPT](https://github.com/mckaywrigley/paul-graham-gpt)

    人工智能搜索和聊天Paul Graham的文章。这是一个很好的演示，关于如何使用[OpenAI Embeddings](https://platform.openai.com/docs/guides/embeddings)
    在ChatGPT API的4096个令牌限制范围内将大型文本数据压缩为提示

    关于这个项目和令牌限制的一些有见地的推文: [@chuangbo](https://twitter.com/chuangbo/status/1631461656151887873), [@dotey](https://twitter.com/dotey/status/1631779232455053313)

- [Elasticsearch + GPT3 Answerer](https://github.com/hunkim/es-gpt)

    拦截Elasticsearch结果并将其发送到GPT3，为您的查询提供准确和相关的答案。


### 工具

- [LlamaIndex 🦙 \(GPT Index\)](https://github.com/jerryjliu/gpt_index)

    LlamaIndex (GPT Index)是一个项目，它提供了一个中央接口来连接您的LLM与外部数据。它有一组数据结构，允许您为各种LLM任务索引数据，并消除对提示大小限制的担忧。

- [gptcache](https://github.com/zilliztech/gptcache) ⭐️

    一个强大的缓存库，可以用来加速和降低依赖LLM服务的聊天应用程序的成本。GPT Cache作为AIGC应用程序的memcache，类似于Redis为传统应用程序工作的方式。

- [Embedchain](https://github.com/embedchain/embedchain) 

    用于在数据集上创建类似机器人的由 LLM 支持的 ChatGPT 的框架

- [Tiktokenizer](https://tiktokenizer.vercel.app/)

    openai的tiktoken库的在线游乐场，为给定的提示计算正确的令牌数量。源代码: [dqbd/tiktokenizer](https://github.com/dqbd/tiktokenizer)

- [ChatGPT Wrapper](https://github.com/mmabrouk/chatgpt-wrapper)

    ChatGPT Wrapper是一个开源的非官方的Power CLI, Python API和Flask API，允许您以编程方式与ChatGPT/GPT4进行交互。支持几种不同的后端连接到ChatGPT模型，包括基于浏览器和基于rest的选项。

- [OpenAI GPT-3.5 Price Calculator](https://openai.deepakness.com/)

    计算使用OpenAI GPT-3.5 API生成一定数量的单词需要花费多少。

- [OpenAI proxy](https://github.com/egoist/openai-proxy)

    OpenAI API反向代理，可以部署在Cloudflare Workers和Vercel Edge上。有助于绕过网络限制或IP速率限制。.


### 文章

- [I got early access to ChatGPT API and then pushed it to it’s limits. Here’s what you need to know. — Buildt](https://www.buildt.ai/blog/vm3qozd4qfrbbyzukqhynrwm9vb9tq)
- [Thread: Advantages of ChatGPT API compared to ChatGPT](https://twitter.com/novoreorx/status/1631250035852861440)
