---
layout: post
title: io.js 本周播报 - 2015.02.27
author: iojs
reference: https://medium.com/node-js-javascript/io-js-week-of-february-17th-9422a589302a
---

ARMv8, C++ Streams, 1.4.1 发布，和解提议等。

<!--more-->

# io.js 1.4.1 发布

_注意：版本 **1.4.0** 原本进行了标记和构建，但在发布过程中发现一个 libuv bug 所以被中止了，没有发布。该 tag 在[`a558cd0a61`](https://github.com/iojs/io.js/commit/a558cd0a61) 之后，但是被删除了。为了避免困惑，直接把版本升到了 1.4.1 。_

## 主要更新

* **process** / **promises**：如果一个 `Promise` 被 reject 了，并且在一次事件循环之内没有添加错误处理 handler， `process` 会触发一个 `'unhandledRejection'` 事件。如果一个 `Promise` 被 reject 了，并且在一次事件循环之后添加了错误处理 handler，`process` 会触发一个 `'rejectionHandled'` 事件。详情参看文档 [process](https://iojs.org/api/process.html) [#758](https://github.com/iojs/io.js/pull/758) (Petka Antonov)
* **streams**：在 `tls.connect()` 时可以将普通 streams 当做 socket 使用 [#926](https://github.com/iojs/io.js/pull/926) (Fedor Indutny)
* **http**：在客户端中止一个 `http.ClientRequest` 时会触发一个新的 `'abort'` 事件。 [#945](https://github.com/iojs/io.js/pull/945) (Evan Lucas)
* **V8**：V8 更新到 4.1.0.21，包含一个修复（但被禁止访问），详情参看 https://code.google.com/p/chromium/issues/detail?id=430201。此次更新因一个非兼容的 ABI 更新受阻，可能会在合并 v8 4.2 时支持。参看讨论 [#952](https://github.com/iojs/io.js/pull/952)。
* **npm**：更新 npm 到 2.6.0. 包含用以支持新 registry 的一些特性，并为 `npm@3` 做准备。详情参看 [npm CHANGELOG.md](https://github.com/npm/npm/blob/master/CHANGELOG.md#v260-2015-02-12)：
  * [`38c4825`](https://github.com/npm/npm/commit/38c48254d3d217b4babf5027cb39492be4052fc2) [#5068](https://github.com/npm/npm/issues/5068) 添加 logout 命令，该命令对基于 bearer 和 basic 的客户端验证会有帮助。([@othiym23](https://github.com/othiym23))
  * [`c8e08e6`](https://github.com/npm/npm/commit/c8e08e6d91f4016c80f572aac5a2080df0f78098) [#6565](https://github.com/npm/npm/issues/6565) 添加警告：`peerDependency` 的行为正在改变，并在文档中添加声明。 ([@othiym23](https://github.com/othiym23))
  * [`7c81a5f`](https://github.com/npm/npm/commit/7c81a5f5f058941f635a92f22641ea68e79b60db) [#7171](https://github.com/npm/npm/issues/7171) 添加警告：`package.json` 中的 `engineStrict` 在下一个主要版本(很快发布!)中将被移除 ([@othiym23](https://github.com/othiym23))
* **libuv**: 更新到 1.4.2 。修复详情参看 [libuv ChangeLog](https://github.com/libuv/libuv/blob/v1.x/ChangeLog)。

# ARM 在 ARMv8 上提供对 io.js 的支持

ARM 联系了 Build 工作组的领导 Rod Vagg，来提供他们对 io.js 项目的支持。ARM 和他的硬件合作伙伴将确保 ARMv8 有一个可行的服务器平台和灵活自然的服务器端 JavaScript，使 io.js 完美的运行在新的 ARMv8 上。

由于 ARMv8 已经被移动设备制造商采用，新版本的 V8 引擎已经有很好的支持。因为 V8 的在 Android 中举足轻重的作用，所以 io.js 非常适合支持和跟踪，它甚至有助于我们与V8团队的新关系。

从 io.js 项目的开始，Rod 就比较重视 io.js 在 ARM 的作用，如物联网、业余爱好者、服务器的使用。我们已经有了每个版本的 ARMv6 builds 用于一些像树莓派之类的设备，以及 ARMv7 builds，用于很多现在流行的设备（包括基于 ARM 云平台的在线实验室，他们也向 io.js 提供帮助）。ARMv8 是这个的延伸，同样对于服务器端的应用有着令人兴奋的潜力，尤其是对64位的支持。

在这个过程中，build 团队已经获得使用 Linaro ARMv8 服务器集群的权利来整合 io.js 的 CI 平台，最终生成常规 ARMv8 二进制版本。

# 社区新鲜事

* [**和解提议**](https://github.com/iojs/io.js/issues/978)：io.js项目正在准备一项计划，将和解带到 Node.js 基金会。来自社区的意见在早期阶段非常重要，所以请发表评论。 
* **新的内部 C++ Streams API**：本周一个新的[新的 C++ Streams API](https://github.com/iojs/io.js/commit/b9686233fc0be679d7ba1262b611711629ee334e) 在 io.js 中发布，允许你可以将TLS stream 包装成另一个 TLS stream。
* **io.js 路线图**：[路线图](https://github.com/iojs/io.js/blob/v1.x/ROADMAP.md)是对 io.js 未来的计划。它展示了 io.js 整体上关于稳定性策略的计划和当务之急。
* **路线图幻灯片完成并准备翻译**：io.js 的路线图介绍幻灯片[已经完成，并准备进行翻译](https://github.com/iojs/roadmap/issues/18)。你能把它展示给你周围的小组吗？留个言，我们将与你一起准备你的展示！
* **微软 Azure 网站 io.js 指南**：微软为 Azure 平台[发布了一篇入门](http://azure.microsoft.com/en-us/documentation/articles/web-sites-nodejs-iojs/)教程，来描述如何在 Azure 网站中使用 io.js。
* **Floobits 迁移到 io.js**：协同编程软件 Floobits [迁移他们的平台到 io.js](https://news.floobits.com/2015/02/23/on-moving-to-io.js/)，部分原因是 Node 版本更新较慢，包含了更多 ES6 特性但没有他们所需的 `--harmony` flag， 而且他们觉得从 0.10.0 到 0.12.0 版本的改变不够大。
* **Anand Mani Sankar 的文章 _Node.js vs io.js: Why the fork?!?_**: Anand 写了一篇非常好的文章，主题是 [io.js 最近的历史](http://anandmanisankar.com/posts/nodejs-iojs-why-the-fork/#.VO82hE60PVw.twitter)和我们希望它实现什么。对于没有从事社区工作的人来说这是一篇很好的文章来了解这些。
* **iojs-jp - 新的 io.js 日文博客**： iojs-jp 社区已经建立了一个[本地化的 io.js 博客](http://blog.iojs.jp/)，以使用他们的语言来宣传相关内容。感兴趣的话来看看吧！
* **iojs-cn - 新的 io.js 中文博客**： 与 iojs-jp 社区类似，iojs-cn 社区建立了一个[本地化的博客](http://cn.iojs.org/)，用中文来发布关于 io.js 的文章。如果对 iojs-cn 或关于 io.js 的中文新闻感兴趣的话一定要来看看！
* **[路线图幻灯片 Review](https://www.youtube.com/watch?v=etI_UD4wXlo)** - 这是在它们被发布之前的一个路线图幻灯片 Review，以确保它们符合项目所坚持的一些东西。

# 以下项目增加对 io.js 的支持
* **[Wallby.js](http://wallabyjs.com/)**，一个 while-you-write JavaScript 测试库， 在 1.0 版本中[增加了对 io.js 的支持](http://dm.gl/2015/02/23/wallaby-version-one/)！
* **[jsdom](https://github.com/tmpvar/jsdom)**，一种 WHATWG DOM 和 HTML 标准的实现，刚刚发布了[ 4.0.0 版本](https://github.com/tmpvar/jsdom/blob/master/Changelog.md#400)，添加了对 io.js 的 _requirement_。
* **[give](https://github.com/mmalecki/give)** 的作者[发推特](https://twitter.com/maciejmalecki/status/569629100215816192)表示新版本的 give 支持 io.js。Give 是一个基于 git 的 node.js/io.js 版本管理工具。
* **Firebase Realtime Client**，Firebase 的官方 web/node.js JavaScript 客户端，[发推特](https://twitter.com/FirebaseRelease/status/570000737343647744)表示在 [2.2.1 版本](https://www.firebase.com/docs/web/changelog.html#section-realtime-client)中增加了对 io.js 的支持。
* **Semaphore**，一个持续集成服务，[发推特](https://twitter.com/semaphoreapp/status/570987355005431809)表示在他们的[平台上于2015年2月24日](https://semaphoreapp.com/blog/2015/02/17/platform-update-on-february-24th.html?utm_source=twitter&utm_medium=social&utm_content=platform_update_launch&utm_campaign=platformupdate)增加了对 io.js 的支持。