# The Zen of Python

The _Zen of Python_ by Tim Peters, and also known as [PEP-20](https://www.python.org/dev/peps/pep-0020/) is a philosophical statement of Python's foundational principles and ideals. It's neither exhaustive nor binding, but it's often quoted in whole or in part when there's any need to determine which of two functionally identical idioms or pieces of code is _better_ or more [Pythonic](pythonic.md).

- Beautiful is better than ugly.
- Explicit is better than implicit.
- Simple is better than complex.
- Complex is better than complicated.
- Flat is better than nested.
- Sparse is better than dense.
- Readability counts.
- Special cases aren't special enough to break the rules.
- Although practicality beats purity.
- Errors should never pass silently.
- Unless explicitly silenced.
- In the face of ambiguity, refuse the temptation to guess.
- There should be one-- and preferably only one --obvious way to do it.
- Although that way may not be obvious at first unless you're Dutch.
- Now is better than never.
- Although never is often better than _right_ now.
- If the implementation is hard to explain, it's a bad idea.
- If the implementation is easy to explain, it may be a good idea.
- Namespaces are one honking great idea -- let's do more of those!

## Easter Egg

If you ever need a refresher, just `import this`. And if you need an example of code that is explicitly _not_ Zen, check out the source of [this](https://github.com/python/cpython/blob/master/Lib/this.py).
