# Pythonic

An adjective used to describe well-constructed, high-quality Python code that is as easily understood and well designed as is possible for the task at hand. A piece of code that is "more Pythonic" will be easier to read and understand, and therefore more pleasurable to use, then "less Pythonic" code that accomplishes the same task.

A quality admired in a Pythonista -- the community's name for an adept Python user -- is the desire to always write code that is as Pythonic as possible.

## Qualities

Any given piece of code tends to be considered more Pythonic if it:

1. Adheres to the principles of the [Zen of Python](zen_of_python.md).
1. Uses the current "best practice" idioms of the language, as the language and those practices evolve.
1. Uses the common style conventions described in [PEP 8](pep_8_style_guide.md)

## Further Reading

- [What is Pythonic](https://blog.startifact.com/posts/older/what-is-pythonic.html)
- [Python Guide](https://docs.python-guide.org/writing/style/)
