# PEP 8 Style

Unlike most earlier languages -- and many newer -- Python has an "official" style guide, and has had one for quite some time.

> One of [Python creator Guido von Rossum]'s key insights is that code is read much more often than it is written. The guidelines provided here are intended to improve the readability of code and make it consistent across the wide spectrum of Python code. As [PEP 20](zen_of_python.md) says, "Readability counts".

The various conventions within it might at times seem arbitrary, but they've been carefully chosen to enhance the readability of Python code, and should generally be adopted and adhered to unless explicitly overridden by a project-specific style guide, which itself should be a derivative of PEP 8.

## Tools

Various tools exist in the Python ecosystem for ensuring that your code doesn't grossly violate PEP 8 conventions. Currently the two most recommended (if opinionated) ones would be [Pylint](https://www.pylint.org/), which will analyze your code for style as well as logical errors, and [Black](https://black.readthedocs.io/en/stable/), which will autoformat your code to take the guesswork out of readability.

## Resources

- [PEP-8](https://www.python.org/dev/peps/pep-0008/)
