# Hints

## General

-  This challenge is all about calculating if a point falls _on, in, or outside_ a given circle.
-  There are two different ways of calculating if a point falls on, in, or outside a circle.
   - This _Stack Overflow_ Post: [Equation for Testing if a Point is Inside a Circle][point-circle-equation] outlines one method.
   - This _DoubleRoot_ post [Position of a point relative to a circle][point-to-circle] outlines a different one.
   - This _Math is Fun_ post covers a more general [Distance Between 2 Points][distance-between-two-points] calculation.
- Because the dart board is a set of _concentric_ circles, the order in which you calculate points could change the answer significantly.
  You should pay attention to which direction your calculations "move" in.
-  Remember that this exercise has many potential solutions and many paths you can take along the way.
   No path is manifestly "better" than another, although a particular path may be more interesting or better suited to what you want to learn or explore right now.
-  Some paths may trade speed for clarity.
   Others might take up more memory but be more scalable or maintainable.
-  We encourage you to try out more than one programming strategy to see what happens.

[point-circle-equation]: https://stackoverflow.com/questions/481144/equation-for-testing-if-a-point-is-inside-a-circle
[point-to-circle]: https://doubleroot.in/lessons/circle/position-of-a-point/
[distance-between-two-points]: https://www.mathsisfun.com/algebra/distance-2-points.html
