# Design

## Learning Objectives

- Access values in a tuple via index using [] (bracket notation).
- Create a tuple via constructor (tuple(_iterable_)) and/or literal (a,b,c or (a, b, c))
- Understand that tuples are an **immutable data type** (like strings). Changing a tuple means creating a new copy.
- Understand that tuples can contain other tuples. (e.g. tuples can be nested).
- Create a new tuple from two or more previous tuples via concatenation using the `+` operator.
- Iterate through a tuple using `for item in`.
- Check for membership of an item in a given tuple using the `in` keyword.
- Understand that it is the comma in a sequence that makes a tuple, and that the () are optional, except for denoting an empty tuple or when omitting them creates ambiguity.

## Out of Scope

- Common Sequence type methods such as `min()`, `max()`, `x.index()`, `x.count()`, `len()`
- Slicing or slice notation ([start:stop:step])
- Additional builtin functions as they relate to this data structure (e.g. `sorted()`, `enumerate()`, `reversed()`, or `hash()`.
- Knowing that tuples can be used as objects in other data structures, -- e.g. " a "List of tuples", "tuples as keys in Dictionaries", or "A Set of tuples".
- Hash-ability and when a tuple is not hash-able.
- Related [collections](https://docs.python.org/3/library/collections.html#collections.namedtuple) module with `namedtuple()`
- Related [dataclass](https://docs.python.org/3.7/library/dataclasses.html) and `@dataclass` decorator
- Memory storage and performance characteristics.

## Concepts

- `tuples`

## Prerequisites

- `booleans`
- `for-loops`
- `functions`
- `if-keyword`
- `in-keyword`
- `integers`
- `return-keyword`
- `strings`
