# Design

## Goal

This concept exercise should convey a basic understanding of how to handle the `for` loop and `while` in Python. This concept exercise should also teach how to interrupt or change the normal flow of a loop using the `break` statement and the `continue` statement.

## Learning objectives

- use `while` to make a loop: execute something as long as an expression/test is `true`
- use `for` to iterate over an iterable object with the `for ... in` pattern. The Membership testing concept (in) is required to address this concept.
- understand the differences between `while` (indefinite, condition-dependent) and `for` (definite, length or count dependent) loops
- use `break` statement to terminate the nearest enclosing loop
- use `continue` statement to continue with the next cycle of the nearest enclosing loop

## Out of scope

- async loops (advanced)

## Concepts

- `while` loops
- `for` loops
- `break` statement
- `continue` statement

## Prerequisites

- `basics`
- `numbers`
- `arithmetic`

## Resources

- [The while key](https://yawpitchroll.com/posts/the-35-words-you-need-to-python/#while)
- [The for loop](https://yawpitchroll.com/posts/the-35-words-you-need-to-python/#for)
- [The break statement](https://yawpitchroll.com/posts/the-35-words-you-need-to-python/#break)
- [The break statement python docs](https://docs.python.org/3/reference/simple_stmts.html#the-break-statement)
- [The continue statement](https://yawpitchroll.com/posts/the-35-words-you-need-to-python/#continue)
- [The continue statement python docs](https://docs.python.org/3/reference/simple_stmts.html#the-continue-statement)
