# Design

## Design

## Goal

The goal of this exercise is to teach helpful string manipulation methods and how to use them in Python.

## Learning objectives

- Know the `str` class and its core methods
- Know when to use methods of str to operate on a string
- Use several of the methods from each grouping below to operate on strings
- Check if a given string ends/begins with the a specified suffix/prefix with the `endswith()`/ `startswith()` methods
- Check if a given string is composed of certain code points/characters by using `isalnum()`, `isalph()`, `isascii()`, `isdecimal()`, `isdigit()`, or `isnumeric()` methods.
- Return a new string that is a transform of the input string using `capitalize()`, `lower()`, `casefold()`, `swapcase()`, `upper()`, or `title()` methods
- Return a new string that has leading/trailing whitespaces removed with `lstrip()`, `rstrip()`, or `strip()` methods
- Check if a given substring is contained within a given string using `in`
- Return a new string that replaces a given substring with a new value using the `replace()` method
- Build a new string from an input iterable with `join()`

## Out of scope

- string formatting methods, "f-strings", "format strings"
- string splitting
- string translate methods (will have their own exercise)
- string constants from the string module
- built-ins that can take a str as an argument
- encoding/decoding & codecs
- the binary sequence types bytes, bytearray, and memoryview
- binary transforms and text transforms
- text encodings

## Concepts

- `string-methods`

## Prerequisites

- `booleans`
- `strings`
- `sequences`, `sequence type`
- `iteration`
