# Design

## Goal

The goal of this exercise is to teach the basics of the `dict` (dictionary, mapping) data type in Python.

## Learning objectives

- create a `dict` via constructor and literal.
- access values in a `dict` via `keys`.
- assign values in a `dict` via key reference.
- check for membership of a key in a given dictionary.
- add new `key`:`value` pairs to the `dict`.
- remove `key`:`value` pairs from the `dict`.
- remove `key`:`value` pairs from the `dict` using `dict.pop()`.
- iterate through a `dict` using `dict.keys()`, `dict.values()`, or `dict.items()`.
- `dict` method `setdefault()`

## Out of scope

- Dictionary comprehensions
- `dict` methods such as `get()` or `clear()`.
- Built-in functions as they relate to this data structure (_e.g._ `copy()`, `len()`, or `enumerate()`.
- Sorting by `keys` or `values`.
- Swapping `keys` for `values`.
- Knowing that Dictionaries can be _nested_, _-- e.g._ ' a dictionary of dictionaries'.
- Mutability
- `copy()` vs `deepcopy()`
- Related `collections` module with `Counter()` and `defaultdict()`
- Memory and performance characteristics.

## Concepts

- `dicts`

## Prerequisites

- `booleans`
- `for-loops`
- `functions`
- `if-keyword`
- `in-keyword`
- `integers`
- `return-keyword`
- `strings`
- `tuples`
- `lists`

## Representer

This exercise does not require any logic to be added to the [representer][representer]

## Analyzer

This exercise does not require any logic to be added to the [analyzer][analyzer].

[builtin-types]: https://github.com/exercism/v3/tree/master/languages/python/reference/concepts/builtin_types
[data-types]: https://github.com/exercism/v3/blob/master/languages/python/reference/concepts/data_structures.md
[analyzer]: https://github.com/exercism/python-analyzer
[representer]: https://github.com/exercism/python-representer
