# Design

## Goal

The goal of this exercise is to teach the student the basics of programming in Python.

## Learning objectives

- Know what a variable (_name_) is.
- Know how to name a variable.
- Know how to bind and re-bind a _name_ to a value (_assign or re-assign a value to a variable or assign a value to a constant_).
- Know what a `function` is and how to define one via `def`.
- Know how to add one or more `parameters` to a function definition.
- Know what the `return` keyword is, and how to use it to return a value from a function.
- Know how to call a function with zero or more arguments.
- Know how to declare an integer and/or float.
- Know how to use mathematical operators `+` and `*` on integers and/or floats.
- Know how to define single- and multi-line comments.
- Know how to define docstrings.

## Out of scope

- built-in types
- built-in data structures
- Classes
- Lambdas
- Methods and other function usages (_functions bound to classes, functions as arguments, nested functions_).
- Memory and performance characteristics.
- Default function parameters.
- Variadic function parameters. (_\*args and \*\*kwargs_)

## Concepts

`basics`:

- function definition & `return` keyword
- integers & floats,
- mathematical operators `+` and `*`
- single and muliti-line comments.
- updating variable values
- using functions
- variables, variable assignment, & variable naming

## Prerequisites

There are no prerequisites for this exercise.

## Representer

This exercise does not require any specific representation logic to be added to the representer.

## Analyzer

This exercise does not require any specific representation logic to be added to the analyzer.
