# Design

## Goal

The goal of this exercise is to introduce the student to the concept of classes.

## Learning objectives

- Understand the _basic_ idea behind Object Oriented Programming (OOP).
- Learn what a class represents.
- Learn what an object is.
- Understand the difference between classes and objects.
- Know how to create a class.
- Know how to create objects.
- Understand that instantiating a class creates an object.
- Know that `__init__()` is a 'constructor' and is used to initialize the object upon instantiation.
- Know that `__init__()` is called upon instantiation/object creation.
- Know what a method is and how it differs from a function.
- Know how to create a method.
- Implement instance variables.
- Implement class variables.
- Understand the difference between instance variables and class variables.
- Use `pass` as a placeholder for class methods.

## Out of scope

- `class-customiation`, including `@classmethod` & `@staticmethod` - but ok to mention in `about.md`.
- `@property` decorator, getters, and setters
- class members & non-public methods
- `class-inheritance`, `multiple-inheritance`, `__super()__`, class mix-ins
- `class-composition`
- `dataclasses`
- performance considerations

## Concepts

- `attributes`
- `classes`
- `methods`
- `objects`
- `OOP`

## Prerequisites

These are the concepts/concept exercises the student needs to complete/understand before solving this concept exercise.

- `basics`
- `bools`
- `comparisons`
- `dicts`
- `iteration`
- `lists`
- `numbers`
- `sequences`
- `sets`
- `strings`
- `tuples`

## Resources

- [Classes (Python tutorial)](https://docs.python.org/3/tutorial/classes.html)
- [Python Data Model - Python Docs](https://docs.python.org/3/reference/datamodel.html#the-standard-type-hierarchy)
- [Real Python: Object-Oriented Programming in Python 3](https://realpython.com/python3-object-oriented-programming/)
- [DigitalOcean: How To Construct Classes & Objects in Python 3](https://www.digitalocean.com/community/tutorials/how-to-construct-classes-and-define-objects-in-python-3)
