# Design

## Goal

This concept exercise should make the student aware of a selection of `list methods` for modifying and manipulating `lists`.

## Learning objectives

- Understand when it is appropriate to use `list methods`
- Understand that most `list methods` mutate the original `list` and **do not** return a new or copied list.
- Use one or more of the below methods to alter a list:
    - Add a single item to the end of a list with the `append()`
    - Remove all items from a list with the `clear()` method
    - Insert an item in a list with the `insert()` method
    - Remove the item at the given index with the `pop()` method
    - Remove an item from a list with the `remove()` method
    - Reverse a list with the `reverse()` method
    - Sort items of a list with the `sort()` method
    - Return a shallow copy of a list with the `copy()` method
    - Return the number of times an item occurs in a `list` with the `count()` method
    - Add all items from another iterable to the end of a list with the `extend()` method
    - Return the index of an item in a list with the `index()` method
- Understand which data in a `list` can be sorted and/or compared

## Out of scope

- Performance considerations

## Concepts

- iterables
- lists
- list methods

## Prerequisites

- basics
- booleans
- methods
- object
- iterables

## Resources

- [Python list methods - Python language reference](https://docs.python.org/3/tutorial/datastructures.html#more-on-lists)
- [Python list methods on python-ds](http://www.python-ds.com/python-3-list-methods)
