# Design

## Goal

The goal of this exercise is to teach the basics of the `list` data type in Python. The exercise will walk the student through how to create lists via various methods, iterate through lists via looping, and access items in various lists through indexing and forming/accessing list slices.

## Learning objectives

- Create a `list` via constructor (`list()`) & literal (`[]`)
- Combine two or more lists by concatenation via `+`
- Check for an items membership/absence in a list using `in`
- Access items in a list via index (`bracket notation`)
- Access a range of items in a list via list slicing (`[start:stop:step]`)
- Usage of `sum()` on a list with numbers
- Usage of `len()` to get the length of a list

## Out of scope

- List Comprehensions (these will be covered in their own concept exercise)
- List methods (`copy()`, `append()`, `sort()` etc)
- How builtin functions relate to lists (`len()`, `max()`, `min()`, `count()`, `sorted()`)
- Construction of complex or nested `lists` (i.e a `list` of `dicts`, a `list` of `lists`, a `list` of `tuples`)
- Consequences and considerations of mutability

## Concepts

- `lists`
- indexing
- slicing
- concatenation

## Prerequisites

- `basics`
- `str`
- `comparisons`
- `conditionals`
