# Hints

## General

## 1. Tracking Poker Rounds

- Lists in Python may be [constructed][constructed] in multiple ways.
- This function should [return][return] a `list`.

## 2. Keeping all Rounds in the Same Place

- Sequence types such as `list` support [common operations][common sequence operations].
- This function should [return][return] a `list`.

## 3. Finding Prior Rounds

- Sequence types such as `list` support a few [common operations][common sequence operations].
- This function should [return][return] a `bool`.

## 4. Averaging Card Values

- To get the average, this function should count how many items are in the `list` and sum up their values. Then, return the sum divided by the count.

## 5. Alternate Averages

- Sequence types such as `list` support a few [common operations][common sequence operations].
- To access an element, use the square brackets (`<list>[]`) notation.
- Remember that the first element of the `list` is at index 0 from the **left-hand** side.
- In Python, negative indexing starts at -1 from the **right-hand** side. This means that you can find the last element of a `list` by using `<list>[-1]`.
- Think about how you could reuse the code from the functions that you have already implemented.

## 6. More Averaging Techniques

- Sequence types such as `list` already support a few [common operations][common sequence operations].
- Think about reusing the code from the functions that you just implemented.
- The slice syntax supports a _step value_ (`<list>[<start>:<stop>:<step>]`).

## 7. Bonus Round Rules

- Lists are _mutable_. Once a `list` is created, you can modify, delete or add any type of element you wish.
- Python provides a wide range of [ways to modify `lists`][ways to modify `lists`].


[common sequence operations]: https://docs.python.org/3/library/stdtypes.html#sequence-types-list-tuple-range
[constructed]: https://docs.python.org/3/library/stdtypes.html#list
[return]: https://www.w3schools.com/python/ref_keyword_return.asp
[ways to modify `lists`]: https://realpython.com/python-lists-tuples/#lists-are-mutable
