# Problem Solving Strategies


As the first article here states, `Problem solving is a meta-skill`.
We find that often, the syntax or structure of a programming language isn't the most difficult part of solving a challenge - figuring out _what to code_ or _where to start_ is.
Developing strategies and a system to break down problems into code-able steps is a **great** skill to cultivate.
Below are some community-sourced articles, videos, and books that can help you develop this super-skill.


- Free Code Camp offers a good overview article on [How to Think Like a Programmer - Lessons in Problem-Solving][free-code-camp-think-like-a-programmer].
- Kurtis Pykes writing for Towards Data Science has a nice [hands-on tutorial for problem-solving][Kurtis Pykes: Hands-on Tutorial - How to Improve Your Problem-Solving Skills as A Programmer].
- UC Berkeley has a nice PDF summary of [G. Polya's Problem Solving Techniques][g-polya-how-to-solve-it-summary].
- Originally written in 1945 as guidance for tackling complicated math problems,[G. Polya's How To Solve It][g-polya-how-to-solve-it] (full book) is still _excellent_ advice for problem-solving in general.
- Mentioned in the Free Code Camp Article, V. Anton Spraul's [Think Like a Programmer: An Introduction to Creative Problem Solving][v-anton-spraul-think-like-a-programmer] is a more modern and programming-focused take on the same general methods Polya outlines for mathematics.
- [Felienne Hermans][felienne-hermans] is more focused on _how_ people learn the art of coding and how that maps to learning in general.
  She has written [The Programmers Brian][programmers-brain-free-online], with strategies for reading code better, thinking about code clearly, writing better code, and becoming a better code collaborator.
  - You can order a physical copy of her book [here][programmers-brain-manning].
  - She also has two interesting videos on the same topic: [How to Teach Programming (and other things??)][felienne-hermans-how-to-teach-programming] and [Programming is Writing is Programming ][felienne-hermans-programming-is-writing-is-programming].
- [Algorithmic Thinking (Daniel Zingaro)][daniel-zingaro-algorithmic-thinking] from No Starch Press and [How to think like a programmer (Paul Vickers)][paul-vickers-how-to-think-like-a-programmer] also cover problem-solving when coding.
- [Computational Thinking: A beginner's guide to problem-solving and programming (Karl Beecher)][beecher-computational-thinking] and [Computational Thinking for the Modern Problem-Solver (Riley and Hunt)][riley-and-hunt-computational-thinking]. Also offer strategies for thinking about problems and breaking them down for coding solutions.
- [From Computing to Computational Thinking (Paul S. Wang)][wang-computational-thinking] is a bit more generalized and academic, but offers problem-solving strategies and structures that can apply to more than coding, and does not require prior programming knowledge.

Some of the books above may also be read through the Association of Computing Machinery library.
Membership (paid) information is available at [acm(dot)org][association-for-computing-machinery].


[Kurtis Pykes: Hands-on Tutorial - How to Improve Your Problem-Solving Skills as A Programmer]: https://towardsdatascience.com/hands-on-tutorial-how-to-improve-your-problem-solving-skills-as-a-programmer-83f0a8d1082f
[association-for-computing-machinery]: https://www.acm.org/membership/membership-benefits
[beecher-computational-thinking]: https://www.karlbeecher.com/project/ct
[daniel-zingaro-algorithmic-thinking]: https://nostarch.com/algorithmic-thinking
[felienne-hermans-how-to-teach-programming]: https://www.youtube.com/watch?v=g1ib43q3uXQ
[felienne-hermans-programming-is-writing-is-programming]: https://www.youtube.com/watch?v=uO3a4HIBDU4
[felienne-hermans]: https://www.felienne.com/
[free-code-camp-think-like-a-programmer]: https://www.freecodecamp.org/news/how-to-think-like-a-programmer-lessons-in-problem-solving-d1d8bf1de7d2/
[g-polya-how-to-solve-it-summary]: https://math.berkeley.edu/~gmelvin/polya.pdf
[g-polya-how-to-solve-it]: https://press.princeton.edu/books/paperback/9780691164076/how-to-solve-it
[paul-vickers-how-to-think-like-a-programmer]: https://www.researchgate.net/publication/236270907_How_to_Think_like_a_Programmer_Problem_Solving_for_the_Bewildered
[programmers-brain-free-online]: https://www.manning.com/books/the-programmers-brain#toc
[programmers-brain-manning]: https://www.manning.com/books/the-programmers-brain
[riley-and-hunt-computational-thinking]: https://www.amazon.com/Computational-Thinking-Problem-Textbooks-Computing-ebook/dp/B00IZL9NQI
[v-anton-spraul-think-like-a-programmer]: https://archive.org/details/think-like-a-programmer/page/n19/mode/2up
[wang-computational-thinking]: https://www.amazon.com/Computing-Computational-Thinking-Paul-Wang-dp-1482217651/dp/1482217651/ref=mt_other?_encoding=UTF8&me=&qid=
