# About

[Python][python docs] is a [dynamic and strongly][dynamic typing in python] typed [object-oriented][object oriented programming] programming language.
It employs both [duck typing][duck typing] and [gradual typing][gradual typing] (via [type hints][type hints]).
It supports multiple programming paradigms including imperative (_object-oriented, procedural_) and declarative (_functional, concurrent_) flavors.
But do not be fooled: while programming across paradigms is fully supported, [everything in Python is an object][everythings an object].


Python was created by Guido van Rossum and first released in 1991.
The [Python Software Foundation][psf] manages and directs resources for Python and CPython development and receives proposals for changes to the language from [members][psf membership] of the community via [Python Enhancement Proposals or PEPs][peps].
It is considered a strong language for programmers [starting their journey][python for beginners], with a welcoming community and many resources available to learners of all levels and persuasions.


Python puts a strong emphasis on code readability and (_similar to Haskell_) uses [significant indentation][significant indentation] to denote function, method, and class definitions.
Code can be written and executed from the command line, in an interactive interpreter session, in [JupyterLab][jupyter] (Jupyter notebook), or a wide variety of [code editors and IDEs][editors for python].

[Python is used extensively][python is used extensively] in scientific computing, finance, games, networking, internet development, and in assembling pipelines of other programs.


The [zen of Python (PEP 20)][the zen of python] and [What is Pythonic?][what is pythonic] lay out additional philosophies and perspectives on the language.


Tests and tooling for this track currently support `3.7` - `3.11.2` (_tests_) and [`Python 3.11.2`][311-new-features] (_tooling_).
It is highly recommended that students upgrade to at least `Python 3.8`, as some features used by this track may not be supported in earlier versions.
That being said, most of the exercises will work with `Python 3.6+`, or even earlier versions.
But we don't guarantee support for versions not listed under [Active Python Releases][active-python-releases].
We will try to note when a feature is only available in a certain version.


Complete documentation for the current release of Python (3.11.x) can be found at [docs.python.org][python docs].

- [Python Tutorial][python tutorial]
- [Python Library Reference][python library reference]
- [Python Language Reference][python language reference]
- [Python HOW TOs][python how tos]
- [Python FAQs][python faqs]
- [Python Glossary of Terms][python glossary of terms]


[311-new-features]: https://docs.python.org/3/whatsnew/3.11.html
[active-python-releases]: https://www.python.org/downloads/
[duck typing]: https://en.wikipedia.org/wiki/Duck_typing
[dynamic typing in python]: https://stackoverflow.com/questions/11328920/is-python-strongly-typed
[editors for python]: https://djangostars.com/blog/python-ide/
[everythings an object]: https://docs.python.org/3/reference/datamodel.html
[gradual typing]: https://en.wikipedia.org/wiki/Gradual_typing
[jupyter]: http://jupyter.org
[object oriented programming]: https://en.wikipedia.org/wiki/Object-oriented_programming
[peps]: https://www.python.org/dev/peps/
[psf membership]: https://www.python.org/psf/membership/
[psf]: https://www.python.org/psf/
[python docs]: https://docs.python.org/3/
[python faqs]: https://docs.python.org/3/faq/index.html
[python for beginners]: https://www.python.org/about/gettingstarted/
[python glossary of terms]: https://docs.python.org/3/glossary.html
[python how tos]: https://docs.python.org/3/howto/index.html
[python is used extensively]: https://www.python.org/about/apps/
[python language reference]: https://docs.python.org/3/reference/index.html
[python library reference]: https://docs.python.org/3/library/index.html
[python tutorial]: https://docs.python.org/3/tutorial/index.html
[significant indentation]: https://docs.python.org/3/reference/lexical_analysis.html#indentation
[the zen of python]: https://www.python.org/dev/peps/pep-0020/
[type hints]: https://docs.python.org/3/library/typing.html
[what is pythonic]: https://blog.startifact.com/posts/older/what-is-pythonic.html
