# IDEA插件简介
**idea插件是一个可以帮助你快速在idea内部启动代码分析并展示分析结果的插件, 你只需要配置一些分析必要的参数, 就可以在本地进行代码分析, 并且可以在idea中以树形结构和标记代码行这些比较直观的方式来查看错误**
# 使用教程
## 前置步骤
**1、安装python3.7, 部署TCA开源版, 在开源版中创建团队和分析方案模板**

**2、在TCA源码的 CodeAnalysis 目录下执行`bash ./scripts/base/install_bin.sh`命令**

**3、配置客户端 config.ini 文件, 打开TCA源码的 `CodeAnalysis/client/config.ini` 文件, 将 config.ini 文件里的`<Server IP地址>`替换成部署的TCA平台的IP (可包含端口号)**
## 安装插件
**在插件源码的TCA目录下执行`gradle build`命令进行构建, 构建成功后会生成zip文件`TCA/build/distributions/TCA-1.0.zip`, 在idea中的插件安装页面点击设置图标, 选择从磁盘安装插件, 选择生成的TCA-1.0.zip文件并打开就能安装, 安装后选择重启idea插件就会生效**

## 配置参数
**python3路径: python3的安装路径, 安装python后执行`which python3`可以查看python3的安装路径.注意python3的版本要求是3.7**

**TCA源码安装路径: 拉取到本地的CodeAnalysis项目的绝对路径 (例如：/data/CodeAnalysis/)**

**个人Token: 在部署的TCA服务的【个人中心】->【个人令牌】中获取**

**分析方案模板ID: TCA服务里创建的分析方案模板的ID, 在分析方案模板的“基础配置”中获取**

**团队唯一标识: 在TCA服务中团队的团队概览页中获取**
## 启动分析
**idea插件有多种方式启动分析**

**1、分析指定文件: 在打开的文件页右键或在idea左侧的项目结构树中对指定文件右键, 在右键弹出的窗口中会有一个`当前路径开启TCA代码分析`选项, 点击按钮就可以分析指定文件**

**2、分析指定目录: 在idea左侧的项目结构树里对指定目录右键, 弹出的窗口中也会有一个`当前路径开启TCA代码分析`选项, 点击就可以分析指定目录下的所有文件**

**3、重新运行上一次目录或文件分析: 安装插件并重启后在idea底部会增加一个窗口, 窗口中的绿色启动按钮的功能就是重新运行上一次目录或文件分析, 点击后会重新执行上一次右键启动的分析**

**4、工程分析: 在窗口中有一个蓝色启动按钮, 点击后即可对整个项目的文件进行分析**

## 查看分析日志和结果
**成功安装idea插件并重启后, 在idea底部会增加一个窗口, 窗口中有两个标签页, 分别是分析日志和分析结果, 启动分析后分析日志页会不停的打印分析日志, 可以根据分析日志查看分析进度和查看分析是否出现异常.**

**分析结果页在分析结束后会以树形结构的方式展示错误信息, 树形结构的根节点是根据用户选择的节点设置的, 在树中会显示目录、文件的问题总数, 以及每个文件的错误列表, 双击错误列表中的具体错误信息可以跳转到出现该错误的代码行, 此外在代码行的头部也会展示对应的错误信息.**

**需要注意的是, 分析日志是追加的形式不断插入到分析日志窗口里的, 而分析结果每一次更新都会覆盖掉前一次的分析结果**

# 源码理解
**本部分主要介绍如何理解此插件的源码**

**idea插件可以启动代码分析的基础是`python3 codepuppy.py quickinit -t TOKEN --scheme-template-id SCHEME_TEMPLATE_ID --org-sid ORG_SID`和`python3 codepuppy.py quickscan -t TOKEN --scheme-template-id SCHEME_TEMPLATE_ID --org-sid ORG_SID -s SOURCE_DIR --file FILE`命令, 这两个命令的功能是初始化工具和执行扫描.**
**idea插件启动分析本质上就是用代码执行这两个命令, 所以idea插件能够正常运行的前提是这两个命令能够正常运行. 代码分析命令执行完后会在client目录下生成分析结果文件`tca_quick_scan_report.json`, idea插件会获取这个文件里的数据, 并进行一系列的处理, 然后展示到idea界面**

## 插件源码结构
### 前置概念
**在idea插件中使用到了idea的一些插件开发概念, 包括服务、窗口和动作.**

**服务: 用于实现应用程序级或项目级功能的一种机制, 可以理解为由交由idea维护的一种应用级或项目级的单例功能. 在TCA插件中我使用应用级服务维护了设置参数信息, 持久化了参数数据, 也让用户的数据可以在idea的所有项目中通用**

**窗口: 就是展示给用户的窗口. 在idea插件中使用UI组件实例的方式创建窗口, 举例: 创建窗口的步骤一般为创建一个页面类的实例, 创建一些UI组件的实例比如文本框、按钮, 然后把这些组件实例添加到页面实例里, 返回这个页面实例给idea, idea就会把页面渲染出来. 需要注意的是idea有一些布局管理器, 比如`BorderLayout`类, 他会把页面分成五个区域, 添加组件实例时可以指定添加到对应区域**

**动作: 具体功能的实现, 动作在idea中一般以按钮的方式展示, 此插件中启动分析的按钮就是一个动作, 可以在配置文件中设置动作按钮的展示位置**

### 代码结构
**插件源码中比较重要的文件是TCA目录下的build.gradle.kts文件和src目录下的所有文件, build.gradle.kts文件主要定义了插件的依赖、构建任务以及其他构建配置, 比如当想让插件使用一些尚未引入的依赖时就可以在这个文件里配置**

**src目录下的文件定义了插件的功能和逻辑, src目录下resource目录中主要包含了用到的图标文件和插件配置文件`plugin.xml`, 配置文件中配置了插件的一些战术信息, 此外配置文件还管理了插件服务、窗口和动作的注册**

**src目录下的java目录则时插件核心功能的实现, java目录下有五个目录, 说一下每个目录包含的功能**

**Action目录: 所有的动作在这里实现包括ClearLogs(清除日志)、MarkCodeLine(标记错误代码行)、MenuSelect(右键代码分析动作), RestartLastAnalysis(重新运行上一次目录或文件分析), StartDirectoryAnalysis(进行目录分析), StartFileAnalysis(进行文件分析), StartProjectAnalysis(进行工程分析)**

**Data目录: 主要用来定义存储数据的类, ProjectErrorData(从分析结果文件里获取数据的类)、ErrorData(存储结果树叶子节点的类)、FileType(存储结果树非叶子节点的类)、MarkCodeMessage(存储标记错误代码数据的类)**

**Listener目录: 监听器类, 这里主要是监听文件的打开操作, 打开文件后在代码行里标记错误信息**

**Setting目录: 用于实现插件的设置功能, AppSettings(实现设置功能的类, 作为应用级服务在配置文件中注册、主要用来持久化存储设置参数)、AppSettingsComponent(编写设置页面的类)、AppSettingsConfigurable(实现设置功能, 包括更新设置和检测参数是否更改等功能, 同样在配置文件中注册)**

**Window目录: 编写插件窗口, MenuFactory(窗口的工厂类, 在配置文件中注册, 工厂类会获取要展示的页面的实例)、TreeNodeType(用来修改结果树展示样式的类)**