# 自定义规则

自定义规则即由业务团队根据自身需求，由业务团队自行设计提供的规则。

## 自定义规则权限说明

- 工具需开放**支持自定义规则**权限，才可添加自定义规则。  

  - 当前平台提供的工具中，仅[TCA-Armory-R](../代码检查/工具/TCA-Armory-R.md)、`RegexFileScan`、`RegexScan`三款工具支持使用用户自定义规则。

  - 开放**支持自定义规则**权限，需平台管理员在**管理入口**-**工具管理**中找到对应工具，并将其权限状态调整为**支持自定义规则**。  

- 自定义规则仅支持团队管理员添加，且默认仅团队内可见。  

  - 满足不同团队自定义规则可能存在的差异和隐私性。  

- 如需将自定义规则加入工具默认规则，需联系工具提供方团队管理员添加。  

## 平台提供的正则工具 TCA-Armory-R 说明

详见[TCA-Armory-R使用手册](../代码检查/工具/TCA-Armory-R.md)。

## 平台提供的正则工具 RegexScan 说明

`正则工具 RegexScan` 即为开放了自定义规则功能的工具，可进入工具管理页面，搜索工具名称`RegexScan`，查看该工具已存在的规则以及根据团队业务需求，添加自定义规则。

适用场景：通过正则表达式，能够匹配到目标代码的情况。

### 自定义规则步骤

1. **根据团队业务需求设计正则表达式**

   ::: tip
   建议先测试好正则表达式是否正确，正则表达式测试网站推荐：[http://tool.oschina.net/regex](http://tool.oschina.net/regex)

   规则示例：

   - 规则分析场景

     分析代码中的 usleep() 方法调用，如果参数小于 100 ，容易造成 CPU 使用率过高，造成性能浪费，判断为缺陷。

   - 正则表达式

     匹配 usleep() 字符串，括号中的内容为 1 位或 2 位整数，那么正则表达式可以写成 `\busleep\s*\(\s*\d{1,2}\s*\)`，这里考虑了字符串中存在空格的情况。
   :::

2. **进入正则工具添加自定义规则**

   进入工具管理页面，找到正则工具`RegexScan`，并点击进入自定义规则列表页，点击添加规则按钮。

3. **填写规则信息**

   **规则参数填写说明（必要）：**

   参数格式类似 ini 的格式， 也就是 key = value 的格式

   - **【必要】** regex 参数，用于指定分析的正则表达式， 例如: `regex = \busleep\s*\(\s*\d{1,2}\s*\)`。

   - **【必要】** msg 参数，用于展现 issue 说明， 例如： `msg = 函数方法%s 已经废弃，请使用 xxx 方法`。

     msg 中的“%s”使用 regex 中的 group（用“()"括起来的部分）一一匹配。

     如果 regex 没有定义 group，则 msg 最多有一个%s, 并由整个 regex 匹配的字符串替代

     如果 msg 里没有包含“%s”，则直接显示 msg

     如果 msg 没有提供，则默认为“发现不规范代码：%s”（不建议使用默认格式，太笼统）

   - **【可选填】** ignore_comment 参数，用于指定是否忽略注释代码，可选值：True、true、False、false 。例如 `ignore_comment=True`, 默认是 False

   - **【可选填】** include 参数，用于将指定分析文件匹配范围，使用 unix 的文件匹配格式，多项使用英文分号;隔开。例如 `include = path/to/dir;path/to/\*.cpp`

   - **【可选填】** exclude 参数，用于指定不分析的文件。格式参考 include 参数。

4. **将自定义规则添加到项目分析方案中**

   添加完成，可在分析方案-代码检查-规则配置中添加该自定义规则
