# 常驻节点分析

::: tip
TCA 客户端除了通过`localscan`命令启动单次的代码分析，也可以作为一个分布式分析节点启动，作为常驻进程，多个节点可以分布式并行执行服务端下发的任务，提高扫描效率。

和本地分析一样，需要先安装环境和必要的工具，并配置好服务端地址。
:::

## 使用场景

- 希望通过并行执行分析来提高分析效率

- 希望尽量使用公共资源或使用专机资源

## 前置步骤

节点机器上具备客户端及客户端相关依赖环境，可查阅[本地分析-前置步骤](本地分析.md#前置步骤)部分进行配置。

## 节点配置

### 配置 `config.ini` 文件

1. 将`<Server IP地址>`替换成实际的 TCA 平台 IP（可包含端口号）。

2. 国内使用 github 拉取网络较慢，推荐使用腾讯工蜂拉取，需要修改以下配置：  
- 修改 `TOOL_CONFIG_URL=https://git.code.tencent.com/TCA/tca-tools/puppy-tools-config.git`    
- 将[腾讯工蜂](https://git.code.tencent.com)的账号密码填写到`TOOL_LOAD_ACCOUNT `中。（注：没有腾讯工蜂账号的需要注册；由于腾讯工蜂的开源仓库也要求使用账号才能拉取，所以此处必须填写账号密码）  

### 启动常驻节点

- 从TCA前端页面中获取 `token`，前往 **个人中心-个人令牌-复制Token**

  ::: tip
  节点仅能分析该`token`具有权限的项目，因此如设置公共的分析节点，推荐使用超级管理员的token。

  可以通过[用户管理页面](../后台管理/用户管理.md)查看到哪些用户是超级管理员。
  :::

- 如启动团队节点，还需获取团队编号：org_sid，获取方式：
从 TCA 平台项目概览页面URL中获取，项目概览URL格式：`http://{域名}/t/{org_sid}/p/{team_name}/profile`


**两种方式可选启动客户端：**
#### 使用客户端源码启动常驻节点

- 如启动公共节点，需进入到源码的`client`目录下，执行命令：
```bash
python3 codepuppy.py -l codepuppy.log start -t <token>
```

- 如启动团队节点，需增加参数 org_sid：
```bash
python3 codepuppy.py -l codepuppy.log start -t <token> --org-sid <org_sid>
```

启动后，可以在命令行输出或`codepuppy.log`中查看运行日志，如果未报异常，且输出`task loop is started.`，表示节点已经正常启动。
#### 使用客户端二进制启动常驻节点

- 如启动公共节点，需进入到源码的`client`目录下，执行命令：
```bash
./codepuppy -l codepuppy.log start -t <token>
```

- 如启动团队节点，需增加参数 org_sid：
```bash
./codepuppy -l codepuppy.log start -t <token> --org-sid <org_sid>
```
启动后，可以在命令行输出或`codepuppy.log`中查看运行日志，如果未报异常，且输出`task loop is started.`，表示节点已经正常启动。

### 管理节点

常驻节点首次启动后，需要到节点管理页面管理节点状态：

1. **设置节点状态：**
  进入 TCA 节点管理页面。`管理入口`-`节点管理`，可以看到当前在线的节点，节点状态默认为`不可用`，需将其设置为**`活跃`**才可用于接收和执行任务。
  也可以按需修改节点名称、标签、负责人等信息。

2. （按需可选）**配置节点工具进程：**
  进入**工具进程配置**页面，对节点支持的工具进程进行管理（默认会全部勾选），未勾选的工具进程，将不会在该节点上执行。

3. （按需可选）**设置节点标签：**
  节点标签会与分析方案中的运行环境标签进行匹配，只有相同标签的任务才会下发到该机器节点上。
