
# 其他配置与用法

### 1. 配置使用本地工具

:::warning
如果由于网络原因，执行时无法从github自动拉取工具，或拉取比较慢，可以参考基础配置腾讯工蜂工具地址，或使用以下方式预先下载好工具，配置使用本地工具目录。
:::

- （1）如果使用的是开源版Client源码，需要在命令行(windows环境下可以启动`git bash`)中执行以下命令：
```bash
bash ./scripts/base/install_bin.sh
```
- （2）下载工具配置库 `https://github.com/TCATools/puppy-tools-config.git` ，存放到 `tools`目录下（如果未生成，可先创建该目录）。
- （3）根据当前机器操作系统，查看`puppy-tools-config`目录下的`linux_tools.ini`或`mac_tools.ini`或`windows_tools.ini`文件，将`[tool_url]`中声明的所有工具下载到 `tools`目录下。
- （4）填写`client/config.ini`中的配置：`USE_LOCAL_TOOL`=`True`，即可使用下载好的本地工具，不自动拉取和更新工具。

### 2. 使用自建git server存放工具

:::warning
如果自己搭建了一套git server，可以将工具配置库 `https://github.com/TCATools/puppy-tools-config.git` 以及里面声明的工具仓库，存放到自建git serevr上。
:::

- （1）将工具配置库 `https://github.com/TCATools/puppy-tools-config.git` 上传到自建git仓库。
- （2）按所需的操作系统，将`puppy-tools-config`仓库下的`linux_tools.ini`或`mac_tools.ini`或`windows_tools.ini`文件中`[tool_url]`声明的所有工具库，上传到自建git仓库。
- （3）修改`linux_tools.ini`或`mac_tools.ini`或`windows_tools.ini`文件中`[base_value]`中的`git_url`为自建git server地址。
- （4）修改`client/config.ini`中的`TOOL_CONFIG_URL`为自建git server的`puppy-tools-config`仓库地址。
- （5）填写`client/config.ini`中的`[TOOL_LOAD_ACCOUNT]`配置，输入有拉取权限的用户名密码，即可使用自建git server拉取工具。

### 3. git lfs带宽和存储配额不够问题

- 如果git拉取工具时，出现git lfs拉取失败，可能是lfs带宽和存储配额不够，可以打开对应的工具github页面，通过`Download ZIP`的方式下载工具压缩包，再解压到`tools`目录下。
