# 代码检查-编译配置

腾讯云代码分析平台支持给编译类的工具或编译型项目配置相关命令。

由于对代码进行编译型分析会存在安全风险，需要用户自行进行专机扫描，申购完成后可联系平台管理员进行相关配置。

::: tip
对于编译型语言，有些分析工具是可以通过分析编译产出的中间文件，更为准确地发现代码质量问题。
:::

---

::: warning
由于对代码进行编译型分析会存在安全风险，需要用户自行进行专机扫描（私有化版由客户自行评估即可）。
:::

---

## 编译所需环境说明（重要）

如果配置了编译命令，则需要在具有代码执行所需的编译环境的节点上执行代码分析。即需要用户在专机上提供编译环境（针对私有化版，客户可根据业务情况选择在公共节点机、用户专机、本地节点机提供编译环境即可）。

如以下一些编译环境：

- JDK 环境及版本

- gradle 环境

- cmake & make 环境

- visual studio 环境

- ...

::: warning
如果机器有多个 JDK 或者 gradle 环境，项目编译需指定 JDK 或 gradle 版本，可以在分析方案的基础属性当中设定相应环境变量。
:::

## 编译配置字段说明

**前置命令**：

通常是项目编译前需要执行的命令，或用于清理之前编译过程的命令，如：`make clean`, `xcodebuild clean [-optionName]`。如无需要，可以不填。

**编译命令**：

项目的编译命令，具体可以**咨询该代码库所属项目的开发**

能够使项目编译成功的编译命令，可以填写多行或用 && 连接命令。

::: tip
前置命令与编译命令是隔离的，即在前置命令中的操作不会对编译命令产生影响。

如在前置命令中 `cd src && export TEST=src`，在执行编译命令时并不会跳到`src`目录和获取`TEST`环境变量。
:::

## 编译配置示例

::: tip
咨询该代码库所属项目的开发，先确保先在本地工程根目录调试通过
:::

### JAVA 项目

**编译命令**：

android-studio 项目编译命令示例

```java
gradle compileDebugSources --no-daemon -Dorg.gradle.jvmargs=
```

ant 项目编译命令示例

```java
ant build
```

### Object-C 项目

**编译命令**：

xcodebuild 命令（确保先在本地工程根目录调试通过）

```objectivec
xcodebuild -target dailybuildipa -configuration DailyBuild -sdk iphonesimulator
```

**环境变量**（分析方案-基础属性中配置）：

```bash
XCODE_VERISON=10.1
```

### C/C++ 项目

**编译命令**：

VS 项目编译命令示例

```cpp
devenv.com demo.sln /Build "Debug|Win32"
# 或
msbuild demo.sln /t:Build /p:Configuration=DebugCopy
```

make 项目编译命令示例

```cpp
make all
```

### C# 项目

**编译命令**：

VS 项目编译命令示例

```cs
devenv.com demo.sln /Build "Debug|Win32"
# 或
msbuild demo.sln /t:Build /p:Configuration=Debug
```
