# 代码扫描管理

## 查看项目扫描最新结果概览
```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/
```

#### 返回结果
```JSON
{
    "data": {
        "lintscan": {
            "issue_open_num": 74,
            "issue_fix_num": 439,
            "issue_detail_num": 310,
            "scan": {
                "id": 1,
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "execute_time": "00:02:17.844712"
            },
            "current_scan": {
                "active_category_detail": {
                    "convention": 70,
                    "other": 4
                },
                "active_severity_detail": {
                    "error": 69,
                    "warning": 5
                },
                "issue_open_num": 74,
                "issue_fix_num": 439
            },
            "total": {
                "state_detail": {
                    "active": 197,
                    "resolved": 13,
                    "closed": 23297
                },
                "category_detail": {
                    "convention": {
                        "active": 184,
                        "resolved": 13,
                        "closed": 21143
                    },
                    "other": {
                        "active": 13,
                        "closed": 154
                    },
                    "correctness": {
                        "closed": 1997
                    },
                    "performance": {
                        "closed": 3
                    }
                },
                "severity_detail": {
                    "error": {
                        "active": 157,
                        "resolved": 11,
                        "closed": 20113
                    },
                    "warning": {
                        "active": 40,
                        "resolved": 2,
                        "closed": 2930
                    },
                    "info": {
                        "closed": 254
                    }
                }
            },
            "status": 0,
            "text": "成功",
            "description": null,
            "scan_summary": {
                "convention": {
                    "error": {
                        "rule_count": 7,
                        "active": 65
                    },
                    "warning": {
                        "rule_count": 2,
                        "active": 5
                    }
                },
                "other": {
                    "error": {
                        "rule_count": 1,
                        "active": 4
                    }
                }
            },
            "total_summary": {
                "correctness": {
                    "error": {
                        "rule_count": 16,
                        "closed": 1315
                    },
                    "warning": {
                        "rule_count": 10,
                        "closed": 629
                    },
                    "info": {
                        "rule_count": 1,
                        "closed": 53
                    }
                },
                "performance": {
                    "warning": {
                        "rule_count": 1,
                        "closed": 3
                    }
                },
                "convention": {
                    "error": {
                        "rule_count": 42,
                        "active": 149,
                        "resolved": 11,
                        "closed": 18778
                    },
                    "warning": {
                        "rule_count": 17,
                        "active": 35,
                        "resolved": 2,
                        "closed": 2298
                    },
                    "info": {
                        "rule_count": 1,
                        "closed": 67
                    }
                },
                "other": {
                    "error": {
                        "rule_count": 2,
                        "active": 8,
                        "closed": 20
                    },
                    "warning": {
                        "rule_count": 1,
                        "active": 5
                    },
                    "info": {
                        "rule_count": 3,
                        "closed": 134
                    }
                }
            }
        },
        "cyclomaticcomplexityscan": {
            "id": 1,
            "scan_revision": "scan_revision",
            "scan_time": "2021-03-11T20:46:44.171607+08:00",
            "default_summary": {
                "min_ccn": 20,
                "over_cc_func_count": 6,
                "under_cc_func_count": 796,
                "diff_over_cc_func_count": 0,
                "over_cc_func_average": 22.333333333333332,
                "cc_func_average": 2.5099750623441395,
                "over_cc_sum": 14,
                "cc_average_of_lines": 1.0422094841063054
            },
            "custom_summary": null,
            "created_time": "2021-03-11T20:48:59.976947+08:00",
            "creator": null,
            "modified_time": "2021-03-11T20:49:00.088841+08:00",
            "modifier": null,
            "deleted_time": null,
            "deleter": null,
            "last_revision": "last_revision",
            "diff_cc_num": 0,
            "cc_open_num": 6,
            "cc_average_of_lines": 1.0422094841063054,
            "cc_fix_num": 0,
            "worse_cc_file_num": 0,
            "min_ccn": 20,
            "code_line_num": 13433,
            "scan": 1
        },
        "duplicatescan": {
            "id": 1,
            "scan_revision": "scan_revision",
            "scan_time": "2021-03-11T20:46:44.171607+08:00",
            "default_summary": {
                "exhi_risk": {
                    "range": [
                        0.2,
                        1
                    ],
                    "file_count": 1,
                    "diff": {
                        "diff_file_count": 0
                    }
                },
                "high_risk": {
                    "range": [
                        0.11,
                        0.2
                    ],
                    "file_count": 3,
                    "diff": {
                        "diff_file_count": 0
                    }
                },
                "midd_risk": {
                    "range": [
                        0.05,
                        0.11
                    ],
                    "file_count": 2,
                    "diff": {
                        "diff_file_count": 0
                    }
                },
                "low_risk": {
                    "range": [
                        0,
                        0.05
                    ],
                    "file_count": 2,
                    "diff": {
                        "diff_file_count": 0
                    }
                }
            },
            "custom_summary": null,
            "last_revision": "last_revision",
            "duplicate_file_count": 8,
            "duplicate_block_count": 55,
            "duplicate_line_count": 1177,
            "diff_duplicate_block_count": 0,
            "diff_duplicate_line_count": 0,
            "close_issue_count": 0,
            "new_issue_count": 0,
            "reopen_issue_count": 5,
            "ignored_issue_count": 0,
            "duplicate_rate": 4.98,
            "unique_duplicate_line_count": 1083,
            "total_duplicate_line_count": 1083,
            "total_line_count": 21745,
            "scan": 1
        },
        "clocscan": {
            "id": 1,
            "scan_revision": "scan_revision",
            "scan_time": "2021-03-11T20:46:44.171607+08:00",
            "last_revision": "last_revision",
            "code_line_num": 140490,
            "comment_line_num": 5410,
            "blank_line_num": 3408,
            "total_line_num": 149308,
            "add_code_line_num": 6673,
            "add_comment_line_num": 2309,
            "add_blank_line_num": 1289,
            "add_total_line_num": 10271,
            "mod_code_line_num": 965,
            "mod_comment_line_num": 297,
            "mod_blank_line_num": 0,
            "mod_total_line_num": 1262,
            "del_code_line_num": 35844,
            "del_comment_line_num": 2117,
            "del_blank_line_num": 1794,
            "del_total_line_num": 39755,
            "scan": 1
        }
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看项目代码最新扫描结果概览

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/latestscan/
```
#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_revision | str | 选填，指定查询的扫描版本号，如不指定则为当前项目最新的一次扫描 |

#### 返回结果
```JSON
{
    "data": {
        "id": 1,                            # 扫描编号
        "repo_id": 1,                       # 代码库编号
        "project_id": 1,                    # 项目编号
        "job_gid": 1,                       # 关联任务编号
        "scan_time": "2021-03-11T20:46:44.171607+08:00",  # 扫描时间
        "current_revision": "current_revision",  # 扫描版本号
        "result_code": 0,                   # 扫描任务结果码，0表示正常
        "result_code_msg": "成功",
        "result_msg": null,
        "lintscan": {                         # 代码扫描结果信息
            "current_scan": {                 # 本次扫描信息
                "active_severity_detail": {   # 不同严重级别的活跃问题数，包含 fatal（1-致命）, error（2-错误）, warning（3-警告）, info（4-提示）
                    "error": 69,              
                    "warning": 5              
                },
                "issue_open_num": 10,         # 本次扫描新发现问题数
                "issue_fix_num": 2            # 本次扫描关闭存量问题数
            },
            "total": {                        # 当前项目整体信息
                "state_detail": {             # 不同处理状态的问题数，包含 active（1-活跃）、resolved（2-已处理）、closed（3-已关闭）
                    "active": 197,            
                    "resolved": 13,
                    "closed": 23297
                },
                "severity_detail": {         # 不同严重级别下不同处理状态的问题量
                    "error": {
                        "active": 157,
                        "resolved": 11,
                        "closed": 20113
                    },
                    "warning": {
                        "active": 40,
                        "resolved": 2,
                        "closed": 2930
                    },
                    "info": {
                        "closed": 254
                    }
                }
            }
        },
        "duplicatescan": {                    # 重复代码扫描结果信息
            "id": 1,                          # 扫描任务编号
            "scan_revision": "scan_revision", # 扫描版本号
            "scan_time": "2021-03-11T20:46:44.171607+08:00",  # 扫描时间
            "default_summary": {              # 默认概览
                "exhi_risk": {                # 极高风险
                    "range": [                # 重复率范围: 0.2-1
                        0.2,
                        1
                    ],
                    "file_count": 1,          # 文件数量
                    "diff": {                 # 增量数据
                        "diff_file_count": 0  # 增量文件数量
                    }
                },
                "high_risk": {                # 高风险
                    "range": [                # 重复率范围：0.11-0.2
                        0.11,
                        0.2
                    ],
                    "file_count": 3,
                    "diff": {
                        "diff_file_count": 0
                    }
                },
                "midd_risk": {                # 中风险
                    "range": [                # 重复率范围：0.05-0.11
                        0.05,
                        0.11
                    ],
                    "file_count": 2,
                    "diff": {
                        "diff_file_count": 0
                    }
                },
                "low_risk": {                 # 低风险
                    "range": [                # 重复率范围：0-0.05
                        0,
                        0.05
                    ],
                    "file_count": 2,
                    "diff": {
                        "diff_file_count": 0
                    }
                }
            },
            "custom_summary": null,           # 自定义概览数据
            "last_revision": "2010ef28ff3a26424d4e8f32df022f90cd682eda",  # 上次扫描版本号
            "duplicate_file_count": 8,        # 重复文件数量
            "duplicate_block_count": 55,      # 重复代码块数量
            "duplicate_line_count": 1177,     # 重复代码行数
            "diff_duplicate_block_count": 0,  # 增量重复代码块数量
            "diff_duplicate_line_count": 0,   # 增量重复代码行数
            "close_issue_count": 0,           # 关闭问题数
            "new_issue_count": 0,             # 新增问题数
            "reopen_issue_count": 5,          # 重新打开问题数
            "ignored_issue_count": 0,         # 忽略问题数
            "duplicate_rate": 4.98,           # 重复率
            "unique_duplicate_line_count": 1083,  # 去重后的重复代码行数
            "total_duplicate_line_count": 1083,   # 项目总的去重后的重复代码行数
            "total_line_count": 21745,            # 项目总行书
            "scan": 1                         # 关联扫描任务编号
        },
        "cyclomaticcomplexityscan": {         # 圈复杂度扫描数据
            "id": 1,                          # 圈复杂度扫描编号
            "scan_revision": "scan_revision", # 扫描版本号
            "scan_time": "2021-03-11T20:46:44.171607+08:00",
            "default_summary": {                      # 默认概览数据
                "min_ccn": 20,                        # 最小圈复杂度阈值
                "over_cc_func_count": 6,              # 超标函数数量
                "under_cc_func_count": 796,           # 未超标函数数量
                "diff_over_cc_func_count": 0,         # 增量超标函数数据
                "over_cc_func_average": 22.333333333333332,  # 平均超标圈复杂度
                "cc_func_average": 2.5099750623441395,  # 平均圈复杂度
                "over_cc_sum": 14,                      # 文件超标方法圈复杂度超过阈值的差值之和
                "cc_average_of_lines": 1.0422094841063054 # 千行代码平均圈复杂度
            },
            "custom_summary": null,                     # 自定义概览数据
            "created_time": "2021-03-11T20:48:59.976947+08:00",
            "creator": null,
            "modified_time": "2021-03-11T20:49:00.088841+08:00",
            "modifier": null,
            "deleted_time": null,
            "deleter": null,
            "last_revision": "last_revision",           # 上一次扫描版本号
            "diff_cc_num": 0,                           # 增量超标函数数量
            "cc_open_num": 6,                           # 超标函数量
            "cc_average_of_lines": 1.0422094841063054,  # 千行代码平均圈复杂度
            "cc_fix_num": 0,                            # 修复数量
            "worse_cc_file_num": 0,                     # 圈复杂度恶化的文件数据
            "min_ccn": 20,                              # 最小圈复杂度阈值
            "code_line_num": 13433,                     # 代码行数
            "scan": 1
        },
        "clocscan": {
            "id": 1,
            "scan_revision": "scan_revision",           # 扫描版本号
            "scan_time": "2021-03-11T20:46:44.171607+08:00",  # 扫描时间
            "last_revision": "last_revision",           # 上一次扫描版本号
            "code_line_num": 140490,                    # 代码行数
            "comment_line_num": 5410,                   # 注释行数
            "blank_line_num": 3408,                     # 空白行数
            "total_line_num": 149308,                   # 总行数
            "add_code_line_num": 6673,                  # 增加的代码行数
            "add_comment_line_num": 2309,               # 增加的注释行数
            "add_blank_line_num": 1289,                 # 增加的空白行数
            "add_total_line_num": 10271,                # 增加的总行数
            "mod_code_line_num": 965,                   # 修改的代码行数
            "mod_comment_line_num": 297,                # 修改的注释行数
            "mod_blank_line_num": 0,                    # 修改的空白行数
            "mod_total_line_num": 1262,                 # 修改的总行数
            "del_code_line_num": 35844,                 # 删除的代码行数
            "del_comment_line_num": 2117,               # 删除的注释行数
            "del_blank_line_num": 1794,                 # 删除的空白行数
            "del_total_line_num": 39755,                # 删除的总行数
            "scan": 1
        }
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```


## 查看项目代码扫描结果概览

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/lintscans/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_time_before | str | 选填，扫描任务起始时间，格式: 2021-01-01 00:00:00 |
| scan_time_after | str | 选填，扫描任务结束时间 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "issue_open_num": 10,             # 本次扫描新发现问题数
                "issue_fix_num": 2,               # 本次扫描关闭存量问题数
                "issue_detail_num": 310,          # 本次扫描上报原始问题数（问题展示会进行聚合）
                "scan": {                         # 扫描信息
                    "id": 1,                      # 扫描任务编号
                    "scan_time": "2021-03-11T20:46:44.171607+08:00",  # 扫描开始时间
                    "execute_time": "00:02:17.844712"                 # 扫描执行耗时
                },
                "current_scan": {                 # 本次扫描信息
                    "active_category_detail": {   # 活跃问题分类，包含 CORRECTNESS（1-功能）、SECURITY（2-安全）、PERFORMANCE（3-性能）、USABILITY（4-可用性）、ACCESSIBILITY（5-无障碍化）、I18N（6-国际化）、CONVENTION（7-代码风格）、OTHER（8-其他）
                        "convention": 70,         # 代码风格类型问题
                        "other": 4                # 其他类型问题
                    },
                    "active_severity_detail": {   # 不同严重级别的活跃问题数，包含 fatal（1-致命）, error（2-错误）, warning（3-警告）, info（4-提示）
                        "error": 69,              
                        "warning": 5              
                    },
                    "issue_open_num": 10,         # 本次扫描新发现问题数
                    "issue_fix_num": 2            # 本次扫描关闭存量问题数
                },
                "total": {                        # 当前项目整体信息
                    "state_detail": {             # 不同处理状态的问题数，包含 active（1-活跃）、resolved（2-已处理）、closed（3-已关闭）
                        "active": 197,            
                        "resolved": 13,
                        "closed": 23297
                    },
                    "category_detail": {          # 不同分类下不同处理状态的问题量
                        "convention": {           
                            "active": 184,
                            "resolved": 13,
                            "closed": 21143
                        },
                        "other": {                
                            "active": 13,
                            "closed": 154
                        },
                        "correctness": {
                            "closed": 1997
                        },
                        "performance": {
                            "closed": 3
                        }
                    },
                    "severity_detail": {         # 不同严重级别下不同处理状态的问题量
                        "error": {
                            "active": 157,
                            "resolved": 11,
                            "closed": 20113
                        },
                        "warning": {
                            "active": 40,
                            "resolved": 2,
                            "closed": 2930
                        },
                        "info": {
                            "closed": 254
                        }
                    }
                },
                "status": 0,                     # 扫描状态，0表示成功
                "text": "成功",
                "description": null,
                "scan_summary": {                # 扫描概览
                    "convention": {              
                        "error": {               
                            "rule_count": 7,     # 规则数
                            "active": 65         # 活跃问题数
                        },
                        "warning": {
                            "rule_count": 2,
                            "active": 5
                        }
                    },
                    "other": {
                        "error": {
                            "rule_count": 1,
                            "active": 4
                        }
                    }
                },
                "total_summary": {
                    "correctness": {
                        "error": {
                            "rule_count": 16,
                            "closed": 1315
                        },
                        "warning": {
                            "rule_count": 10,
                            "closed": 629
                        },
                        "info": {
                            "rule_count": 1,
                            "closed": 53
                        }
                    },
                    "performance": {
                        "warning": {
                            "rule_count": 1,
                            "closed": 3
                        }
                    },
                    "convention": {
                        "error": {
                            "rule_count": 42,
                            "active": 149,
                            "resolved": 11,
                            "closed": 18778
                        },
                        "warning": {
                            "rule_count": 17,
                            "active": 35,
                            "resolved": 2,
                            "closed": 2298
                        },
                        "info": {
                            "rule_count": 1,
                            "closed": 67
                        }
                    },
                    "other": {
                        "error": {
                            "rule_count": 2,
                            "active": 8,
                            "closed": 20
                        },
                        "warning": {
                            "rule_count": 1,
                            "active": 5
                        },
                        "info": {
                            "rule_count": 3,
                            "closed": 134
                        }
                    }
                }
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看项目代码度量圈复杂度结果概览
```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/cycscans/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_time_before | str | 选填，扫描任务起始时间，格式: 2021-01-01 00:00:00 |
| scan_time_after | str | 选填，扫描任务结束时间 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "scan_revision": "scan_revision",
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "default_summary": {
                    "min_ccn": 20,
                    "over_cc_func_count": 6,
                    "under_cc_func_count": 796,
                    "diff_over_cc_func_count": 0,
                    "over_cc_func_average": 22.333333333333332,
                    "cc_func_average": 2.5099750623441395,
                    "over_cc_sum": 14,
                    "cc_average_of_lines": 1.0422094841063054
                },
                "custom_summary": null,
                "created_time": "2021-03-11T20:48:59.976947+08:00",
                "creator": null,
                "modified_time": "2021-03-11T20:49:00.088841+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "last_revision": "last_revision",
                "diff_cc_num": 0,
                "cc_open_num": 6,
                "cc_average_of_lines": 1.0422094841063054,
                "cc_fix_num": 0,
                "worse_cc_file_num": 0,
                "min_ccn": 20,
                "code_line_num": 13433,
                "scan": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看项目代码度量重复代码结果概览

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/dupscans/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_time_before | str | 选填，扫描任务起始时间，格式: 2021-01-01 00:00:00 |
| scan_time_after | str | 选填，扫描任务结束时间 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "scan_revision": "scan_revision",
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "default_summary": {
                    "exhi_risk": {
                        "range": [
                            0.2,
                            1
                        ],
                        "file_count": 1,
                        "diff": {
                            "diff_file_count": 0
                        }
                    },
                    "high_risk": {
                        "range": [
                            0.11,
                            0.2
                        ],
                        "file_count": 3,
                        "diff": {
                            "diff_file_count": 0
                        }
                    },
                    "midd_risk": {
                        "range": [
                            0.05,
                            0.11
                        ],
                        "file_count": 2,
                        "diff": {
                            "diff_file_count": 0
                        }
                    },
                    "low_risk": {
                        "range": [
                            0,
                            0.05
                        ],
                        "file_count": 2,
                        "diff": {
                            "diff_file_count": 0
                        }
                    }
                },
                "custom_summary": null,
                "last_revision": "last_revision",
                "duplicate_file_count": 8,
                "duplicate_block_count": 55,
                "duplicate_line_count": 1177,
                "diff_duplicate_block_count": 0,
                "diff_duplicate_line_count": 0,
                "close_issue_count": 0,
                "new_issue_count": 0,
                "reopen_issue_count": 5,
                "ignored_issue_count": 0,
                "duplicate_rate": 4.98,
                "unique_duplicate_line_count": 1083,
                "total_duplicate_line_count": 1083,
                "total_line_count": 21745,
                "scan": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看项目代码度量代码统计结果概览

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/overview/clocscans/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_time_before | str | 选填，扫描任务起始时间，格式: 2021-01-01 00:00:00 |
| scan_time_after | str | 选填，扫描任务结束时间 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "scan_revision": "scan_revision",
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "last_revision": "last_revision",
                "code_line_num": 140490,
                "comment_line_num": 5410,
                "blank_line_num": 3408,
                "total_line_num": 149308,
                "add_code_line_num": 6673,
                "add_comment_line_num": 2309,
                "add_blank_line_num": 1289,
                "add_total_line_num": 10271,
                "mod_code_line_num": 965,
                "mod_comment_line_num": 297,
                "mod_blank_line_num": 0,
                "mod_total_line_num": 1262,
                "del_code_line_num": 35844,
                "del_comment_line_num": 2117,
                "del_blank_line_num": 1794,
                "del_total_line_num": 39755,
                "scan": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

