# 任务管理模块

## 执行指定代码库指定分析项目扫描任务

```
POST /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/scans/create/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| incr_scan | bool | 选填，增量扫描标志，true表示增量，false表示全量 |
| async_flag | bool | 选填，异步启动标志，true表示异步，false表示同步，建议选择异步 |
| force_create | bool | 选填，强制启动标志，true表示强制启动，不等待上一个任务结束 |

#### 返回结果
```JSON
{
    "job": {
        "id": 7974
    },
    "scan": {
        "id": 5528
    }
}
```

## 查看指定项目的任务列表
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/jobs/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| create_time_gte | datetime | 选填，最小任务启动时间 |
| create_time_lte | datetime | 选填，最大任务启动时间 |
| result_code_gte | int | 选填，最小错误码值 |
| result_code_lte | int | 选填，最大错误码值 |
| result_msg | str | 选填，结果信息 |
| state | int | 选填，任务状态, 0为等待中，1为执行中，2为关闭，3为入库中，可多选，格式为1,2,3 |
| created_from | str | 选填，创建来源 |
| creator | str | 选填，创建用户 |


#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "state": 2,
                "result_code": 0,
                "result_msg": "success",
                "code_line_num": 1000,
                "comment_line_num": 5,
                "blank_line_num": 305,
                "total_line_num": 1400
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的指定任务详情

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/jobs/<job_id>/detail/
```

#### 返回结果
```JSON
{
    "data": {
        "id": 1,
        "scan_id": 1,
        "create_time": "2021-01-28T10:27:26.442961+08:00",
        "waiting_time": "1",
        "start_time": "2021-01-28T11:14:56.760427+08:00",
        "execute_time": "3",
        "project": {
            "id": 1,
            "branch": "master",
            "repo_id": 1,
            "scan_scheme": 1,
            "repo_scm_url": "http://github.com/xxx/test_demo.git"
        },
        "end_time": "2021-01-28T11:14:59.760427+08:00",
        "expire_time": "2021-01-28T14:07:52.968932+08:00",
        "task_num": 1,
        "task_done": 1,
        "tasks": [
            {
                "id": 1,
                "module": "codelint",
                "task_name": "pylint",
                "progress_rate": 1,
                "state": 2,
                "result_code": 0,
                "result_msg": "success",
                "result_path": null
            }
        ],
        "co_jobs": [],
        "state": 2,
        "result_code": 0,
        "result_code_msg": null,
        "result_msg": "success",
        "result_path": null,
        "remarks": null,
        "remarked_by": null,
        "code_line_num": 1000,
        "comment_line_num": 5,
        "blank_line_num": 305,
        "total_line_num": 1400,
        "created_from": "codedog_web",
        "creator": "creator"
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

