# 代码扫描数据管理

## 查看扫描问题列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codelint/issues/
```

#### 参数
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| state | str | 选填，问题状态, 1为未处理，2为已处理，3为关闭，可多选，格式为1,2,3 |
| severity | str | 选填，严重程度, 1为致命，2为错误，3为警告，4为提示，可多选，格式为1,2,3,4 |
| resolution | str | 选填，解决方式, 0为无，1为修复，2为无需修复，3为误报，4为重复单过滤，5为路径过滤，6为规则移除 |
| author | str | 选填，问题责任人 |
| scan_open | int | 选填，发现问题的扫描编号 |
| scan_fix | int | 选填，修复问题的扫描编号 |
| ci_time_gte | str | 选填，修复问题的起始时间，格式为"2021-01-01 00:00:00" |
| ci_time_lte | str | 选填，修复问题的结束时间 |
| file_path | str | 选填，文件路径 |
| checkrule_display_name | str | 选填，检查规则名 |
| checkpackage | int | 选填，问题所属的规则包 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "file_path": "test/demo.py",
                "project": 1,
                "repo": 1,
                "checkrule_real_name": "xxx",
                "checkrule_display_name": "xxx",
                "checktool_name": "xxx",
                "msg": "xxx",
                "state": 3,
                "resolution": 1,
                "author": "author",
                "author_email": null,
                "severity": 2,
                "revision": "revision",
                "ci_time": "2021-02-02T13:31:38+08:00",
                "file_owners": null,
                "is_external": false,
                "scm_url": "",
                "real_file_path": "",
                "scan_open": 1,
                "scan_fix": 2,
                "fixed_time": "2021-02-19T15:25:15.152350+08:00"
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看问题详情
```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codelint/issues/<issue_id>/
```

#### 返回结果
```JSON
{
    "data": {
        "id": 1,
        "issue_details": [
            {
                "id": 1,
                "issue_refers": [],
                "creator": null,
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "issuedetail_uuid": "0fcc376e-7283-11eb-bd53-5254005e71ca",
                "checkrule_real_name": "xxx",
                "checktool_name": "xxx",
                "author": "author",
                "author_email": null,
                "line": 1809,
                "column": 15,
                "scan_revision": "scan_revision",
                "revision": "revision",
                "ci_time": "2021-02-02T13:31:38+08:00",
                "real_revision": "",
                "created_time": "2021-02-19T15:21:19.625658+08:00",
                "modified_time": "2021-02-19T15:21:19.625662+08:00",
                "issue": null,
                "project": 1
            }
        ],
        "is_external": false,
        "repo": 1,
        "author": "author",
        "created_time": "2021-02-19T15:21:19.625685+08:00",
        "creator": null,
        "modifier": null,
        "deleted_time": null,
        "deleter": null,
        "file_path": "test/demo.py",
        "file_hash": "xxx",
        "scm_url": "",
        "real_file_path": "",
        "checkrule_gid": 1,
        "checkrule_real_name": "xxx",
        "checkrule_display_name": "xxx",
        "checkrule_rule_title": "xxx",
        "checktool_name": "xxx",
        "category": 7,
        "state": 3,
        "resolution": 1,
        "scan_revision": null,
        "severity": 2,
        "language": "python",
        "revision": "revision",
        "ci_time": "2021-02-02T13:31:38+08:00",
        "file_owners": null,
        "fixed_time": "2021-02-19T15:25:15.152350+08:00",
        "tapd_ws_id": null,
        "tapd_bug_id": null,
        "modified_time": "2021-02-19T15:25:17.807478+08:00",
        "project": 1,
        "scan_open": 1,
        "scan_fix": 2
    },
    "code": 0,
    "msg": "xxx",
    "status_code": 200
}
```

## 查看每次扫描的问题列表
```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codelint/scans/<scan_id>/issues/
```
#### 参数
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| state | str | 选填，问题状态, 1为未处理，2为已处理，3为关闭，可多选，格式为1,2,3 |
| severity | str | 选填，严重程度, 1为致命，2为错误，3为警告，4为提示，可多选，格式为1,2,3,4 |
| resolution | str | 选填，解决方式, 0为无，1为修复，2为无需修复，3为误报，4为重复单过滤，5为路径过滤，6为规则移除 |
| author | str | 选填，问题责任人 |
| scan_open_id | int | 选填，发现问题的扫描编号 |
| scan_fix_id | int | 选填，修复问题的扫描编号 |
| ci_time_gte | str | 选填，修复问题的起始时间 |
| ci_time_lte | str | 选填，修复问题的结束时间 |
| file_path | str | 选填，文件路径 |
| checkrule_display_name | str | 选填，检查规则名 |
| checkpackage | int | 选填，问题所属的规则包 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo_id": 1,
                "project_id": 1,
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "file_path": "test/demo.py",
                "scm_url": "",
                "real_file_path": "",
                "line": 21,
                "column": 68,
                "checkrule_gid": 1,
                "checkrule_real_name": "xxx",
                "checkrule_display_name": "xxx",
                "checkrule_rule_title": "xxx",
                "checktool_name": "xxx",
                "category": 7,
                "msg": "xxx",
                "state": 1,
                "resolution": null,
                "author": "author",
                "scan_open_id": 1,
                "scan_fix_id": null,
                "issuedetail_uuid": "26d7ba88-8268-11eb-a304-5254005e71ca",
                "scan_revision": "scan_revision",
                "real_revision": "",
                "severity": 2,
                "language": "python",
                "revision": "revision",
                "ci_time": "2019-07-01T10:28:19+08:00",
                "file_owners": null,
                "created_time": "2021-03-11T20:49:00.539537+08:00",
                "fixed_time": null
            }
        ]
    },
    "code": 0,
    "msg": "xxx",
    "status_code": 200
}
```
    

## 查看指定CR扫描的问题列表
```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codelint/crscans/<scan_id>/issues/
```
#### 参数
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| state | str | 选填，问题状态, 1为未处理，2为已处理，3为关闭，可多选，格式为1,2,3 |
| severity | str | 选填，严重程度, 1为致命，2为错误，3为警告，4为提示，可多选，格式为1,2,3,4 |
| resolution | str | 选填，解决方式, 0为无，1为修复，2为无需修复，3为误报，4为重复单过滤，5为路径过滤，6为规则移除 |
| author | str | 选填，问题责任人 |
| scan_open_id | int | 选填，发现问题的扫描编号 |
| scan_fix_id | int | 选填，修复问题的扫描编号 |
| ci_time_gte | str | 选填，修复问题的起始时间 |
| ci_time_lte | str | 选填，修复问题的结束时间 |
| file_path | str | 选填，文件路径 |
| checkrule_display_name | str | 选填，检查规则名 |
| checkpackage | int | 选填，问题所属的规则包 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo_id": 1,
                "project_id": 1,
                "scan_time": "2021-03-11T20:46:44.171607+08:00",
                "file_path": "test/demo.py",
                "scm_url": "",
                "real_file_path": "",
                "line": 21,
                "column": 68,
                "checkrule_gid": 1,
                "checkrule_real_name": "xxx",
                "checkrule_display_name": "xxx",
                "checkrule_rule_title": "xxx",
                "checktool_name": "xxx",
                "category": 7,
                "msg": "xxx",
                "state": 1,
                "resolution": null,
                "author": "author",
                "scan_open_id": 1,
                "scan_fix_id": null,
                "issuedetail_uuid": "26d7ba88-8268-11eb-a304-5254005e71ca",
                "scan_revision": "scan_revision",
                "real_revision": "",
                "severity": 2,
                "language": "python",
                "revision": "revision",
                "ci_time": "2019-07-01T10:28:19+08:00",
                "file_owners": null,
                "created_time": "2021-03-11T20:49:00.539537+08:00",
                "fixed_time": null
            }
        ]
    },
    "code": 0,
    "msg": "xxx",
    "status_code": 200
}
```
