# 代码度量数据管理

## 查看指定项目的圈复杂度文件列表

```bash
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/ccfiles/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| state | str | 选填，问题状态, 1为未处理，2为已处理，3为关闭，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| scan_open | int | 选填，发现问题的扫描编号 |
| scan_close | int | 选填，修复问题的扫描编号 |
| worse | boolean | 选填，圈复杂度是否恶化 |
| over_cc_sum_gte | int |选填， 圈复杂度总和最小值 |
| over_cc_sum_lte | int | 选填，圈复杂度总和最大值 |
| over_cc_avg_gte | int | 选填，平均圈复杂度最小值 |
| over_cc_avg_lte | int | 选填，平均圈复杂度总和最大值 |
| over_cc_func_count_gte | int | 选填，超标圈复杂度函数个数最小值 |
| over_cc_func_count_lte | int | 选填，超标圈复杂度函数个数最大值 |

#### 返回参数

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "created_time": "2021-02-19T15:30:20.968525+08:00",
                "creator": null,
                "modified_time": "2021-02-19T15:30:20.968532+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "ccn": 22,
                "g_cc_hash": null,
                "cc_hash": null,
                "file_path": "test/demo.py",
                "func_name": "test_func",
                "func_param_num": 4,
                "long_name": "test_func( project , result_data , scan , task_params )",
                "change_type": 0,
                "status": 1,
                "last_modifier": "author",
                "author": null,
                "related_modifiers": "author,author2",
                "is_tapdbug": false,
                "ignore_time": null,
                "is_latest": true,
                "language": "python",
                "revision": "revision",
                "ci_time": "2020-03-18T19:46:48+08:00",
                "diff_ccn": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": null
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的圈复杂度文件问题列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/ccfiles/<file_id>/ccissues/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| status | str | 选填，问题状态，1为需要关注，2为无需关注，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| ccn_gte | str | 选填，圈复杂度最小值 |
| ccn_lte | str | 选填，圈复杂度最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "created_time": "2021-02-19T15:30:20.968525+08:00",
                "creator": null,
                "modified_time": "2021-02-19T15:30:20.968532+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "ccn": 22,
                "g_cc_hash": null,
                "cc_hash": null,
                "file_path": "test/demo.py",
                "func_name": "test_func",
                "func_param_num": 4,
                "long_name": "test_func( project , result_data , scan , task_params )",
                "change_type": 0,
                "status": 1,
                "last_modifier": "author",
                "author": null,
                "related_modifiers": "author,author2",
                "is_tapdbug": false,
                "ignore_time": null,
                "is_latest": true,
                "language": "python",
                "revision": "revision",
                "ci_time": "2020-03-18T19:46:48+08:00",
                "diff_ccn": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": null
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的圈复杂度问题列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/ccissues/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| status | str | 选填，问题状态，1为需要关注，2为无需关注，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| ccn_gte | str | 选填，圈复杂度最小值 |
| ccn_lte | str | 选填，圈复杂度最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "created_time": "2021-02-19T15:30:20.968525+08:00",
                "creator": null,
                "modified_time": "2021-02-19T15:30:20.968532+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "ccn": 22,
                "g_cc_hash": null,
                "cc_hash": null,
                "file_path": "test/demo.py",
                "func_name": "test_func",
                "func_param_num": 4,
                "long_name": "test_func( project , result_data , scan , task_params )",
                "change_type": 0,
                "status": 1,
                "last_modifier": "author",
                "author": null,
                "related_modifiers": "author,author2",
                "is_tapdbug": false,
                "ignore_time": null,
                "is_latest": true,
                "language": "python",
                "revision": "revision",
                "ci_time": "2020-03-18T19:46:48+08:00",
                "diff_ccn": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": null
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目指定扫描的圈复杂度文件列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/scans/<scan_id>/ccfiles/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| state | str | 选填，问题状态, 1为未处理，2为已处理，3为关闭，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| scan_open_id | int | 选填，发现问题的扫描编号 |
| scan_close_id | int | 选填，修复问题的扫描编号 |
| worse | boolean | 选填，圈复杂度是否恶化 |
| over_cc_sum_gte | int | 选填，圈复杂度总和最小值 |
| over_cc_sum_lte | int | 选填，圈复杂度总和最大值 |
| over_cc_avg_gte | int | 选填，平均圈复杂度最小值 |
| over_cc_avg_lte | int | 选填，平均圈复杂度总和最大值 |
| over_cc_func_count_gte | int | 选填，超标圈复杂度函数个数最小值 |
| over_cc_func_count_lte | int | 选填，超标圈复杂度函数个数最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 32,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "tapd_url": null,
                "created_time": "2020-06-02T10:59:09.418250+08:00",
                "creator": null,
                "modified_time": "2020-06-03T16:17:40.892224+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "over_func_cc": 0,
                "over_cc_sum": 0,
                "over_cc_avg": 0,
                "over_cc_func_count": 0,
                "diff_over_func_cc": 0,
                "diff_over_cc_sum": 0,
                "diff_over_cc_avg": 0,
                "diff_over_cc_func_count": 0,
                "worse": false,
                "file_path": "test/demo.py",
                "state": 3,
                "change_type": 0,
                "last_modifier": "author1",
                "author": null,
                "related_modifiers": "author1;author2",
                "file_owners": null,
                "language": "python",
                "tapd_ws_id": null,
                "tapd_bug_id": null,
                "revision": null,
                "ci_time": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": 2
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目指定扫描的圈复杂度文件问题列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/scans/<scan_id>/ccfiles/<file_id>/ccissues/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| status | str | 选填，问题状态，1为需要关注，2为无需关注，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| ccn_gte | str | 选填，圈复杂度最小值 |
| ccn_lte | str | 选填，圈复杂度最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "created_time": "2021-02-19T15:30:20.968525+08:00",
                "creator": null,
                "modified_time": "2021-02-19T15:30:20.968532+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "ccn": 22,
                "g_cc_hash": null,
                "cc_hash": null,
                "file_path": "test/demo.py",
                "func_name": "test_func",
                "func_param_num": 4,
                "long_name": "test_func( project , result_data , scan , task_params )",
                "change_type": 0,
                "status": 1,
                "last_modifier": "author",
                "author": null,
                "related_modifiers": "author,author2",
                "is_tapdbug": false,
                "ignore_time": null,
                "is_latest": true,
                "language": "python",
                "revision": "revision",
                "ci_time": "2020-03-18T19:46:48+08:00",
                "diff_ccn": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": null
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目指定扫描的圈复杂度问题列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/scans/<scan_id>/ccissues/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| status | str | 选填，问题状态，1为需要关注，2为无需关注，可多选，格式为1,2,3 |
| change_type | str | 选填，圈复杂度变化情况，0为无，1为新增，2为删除，3为无变化，可多选，格式为1,2,3 |
| author | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| ccn_gte | str | 选填，圈复杂度最小值 |
| ccn_lte | str | 选填，圈复杂度最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "created_time": "2021-02-19T15:30:20.968525+08:00",
                "creator": null,
                "modified_time": "2021-02-19T15:30:20.968532+08:00",
                "modifier": null,
                "deleted_time": null,
                "deleter": null,
                "ccn": 22,
                "g_cc_hash": null,
                "cc_hash": null,
                "file_path": "test/demo.py",
                "func_name": "test_func",
                "func_param_num": 4,
                "long_name": "test_func( project , result_data , scan , task_params )",
                "change_type": 0,
                "status": 1,
                "last_modifier": "author",
                "author": null,
                "related_modifiers": "author,author2",
                "is_tapdbug": false,
                "ignore_time": null,
                "is_latest": true,
                "language": "python",
                "revision": "revision",
                "ci_time": "2020-03-18T19:46:48+08:00",
                "diff_ccn": null,
                "project": 1,
                "scan_open": 1,
                "scan_close": null
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的重复文件列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/dupfiles/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| issue__state | str | 选填，问题状态, 1为未处理，2为可忽略，3为关闭，可多选，格式为1,2,3 |
| change_type | str | 选填，重复文件更改类型，add为新增，del为删除，mod为删除，可多选，格式为add,del,mod |
| issue__owner | str | 选填，问题责任人 |
| last_modifier | str | 选填，最近修改人 |
| file_path | str | 选填，文件路径 |
| duplicate_rate_gte | int | 选填，重复率最小值 |
| duplicate_rate_lte | int | 选填，重复率最大值 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "repo": 1,
                "issue": {
                    "id": 1,
                    "state": 1,
                    "owner": "author"
                },
                "project_id": 1,
                "scan_id": 1,
                "issue_id": 1,
                "issue_state": 1,
                "issue_owner": "author",
                "dir_path": "test",
                "file_name": "demo.py",
                "file_path": "test/demo.py",
                "duplicate_rate": 4.63,
                "total_line_count": 259,
                "total_duplicate_line_count": 12,
                "distinct_hash_num": 1,
                "block_num": 1,
                "last_modifier": "author",
                "change_type": null,
                "scm_revision": "12345678abc",
                "is_latest": true
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
} 
```

## 查看指定项目的指定重复文件

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/dupfiles/<file_id>/
```

#### 返回结果

```JSON
{
    "data": {
        "id": 1,
        "repo": 1,
        "issue": {
            "id": 1,
            "state": 1,
            "owner": "author"
        },
        "blocks": [
            {
                "id": 1,
                "duplicate_file": 1,
                "project_id": 1,
                "scan_id": 1,
                "duplicate_file_id": 1,
                "token_num": 120,
                "duplicate_times": 2,
                "duplicate_rate": 4.63,
                "start_line_num": 216,
                "end_line_num": 227,
                "duplicate_line_count": 12,
                "last_modifier": "author",
                "change_type": null,
                "related_modifiers": "author"
            }
        ],
        "duplicate_rate_trend": 0.0,
        "project_id": 1815,
        "scan_id": 488,
        "issue_id": 3,
        "issue_state": 1,
        "issue_owner": "author",
        "dir_path": "test",
        "file_name": "demo.py",
        "file_path": "test/demo.py",
        "duplicate_rate": 4.63,
        "total_line_count": 259,
        "total_duplicate_line_count": 12,
        "distinct_hash_num": 1,
        "block_num": 1,
        "last_modifier": "author",
        "change_type": null,
        "scm_revision": "xxx",
        "is_latest": true
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的指定文件的重复块列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/dupfiles/<file_id>/blocks/
```

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "duplicate_file": 1,
                "project_id": 1,
                "scan_id": 1,
                "duplicate_file_id": 1,
                "token_num": 120,
                "duplicate_times": 2,
                "duplicate_rate": 4.63,
                "start_line_num": 216,
                "end_line_num": 227,
                "duplicate_line_count": 12,
                "last_modifier": "author",
                "change_type": null,
                "related_modifiers": "author"
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定项目的文件行数列表

```
GET /server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/clocfiles/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| change_type | str | 选填，改变类型（add、mod、del），支持多值，使用英文逗号','分隔 |
| file_path | str | 选填，文件路径 |

#### 返回结果

```JSON
{
    "data": {
        "count": 1,
        "next": "",
        "previous": null,
        "results": [
            {
                "id": 1,
                "code_line_num": 108587,
                "comment_line_num": 0,
                "blank_line_num": 0,
                "total_line_num": 108587,
                "add_code_line_num": 108587,
                "add_comment_line_num": 0,
                "add_blank_line_num": 0,
                "add_total_line_num": 108587,
                "mod_code_line_num": 0,
                "mod_comment_line_num": 0,
                "mod_blank_line_num": 0,
                "mod_total_line_num": 0,
                "del_code_line_num": 0,
                "del_comment_line_num": 0,
                "del_blank_line_num": 0,
                "del_total_line_num": 0,
                "project_id": 1,
                "scan_id": 1,
                "is_latest": true,
                "dir_path": "test",
                "file_name": "test.json",
                "language": "JSON",
                "change_type": "add"
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}    
```

## 查看指定项目的语言列表

```
GET server/analysis/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/<project_id>/codemetric/cloclangs/
```

#### 返回结果

```JSON
{
    "data": {
        "count": 2,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "code_line_num": 9753,
                "comment_line_num": 4220,
                "blank_line_num": 2454,
                "total_line_num": 16427,
                "add_code_line_num": 9753,
                "add_comment_line_num": 4220,
                "add_blank_line_num": 2454,
                "add_total_line_num": 16427,
                "mod_code_line_num": 0,
                "mod_comment_line_num": 0,
                "mod_blank_line_num": 0,
                "mod_total_line_num": 0,
                "del_code_line_num": 0,
                "del_comment_line_num": 0,
                "del_blank_line_num": 0,
                "del_total_line_num": 0,
                "project_id": 1815,
                "scan_id": 695,
                "is_latest": true,
                "name": "Python",
                "file_num": 165
            },
            {
                "id": 2,
                "code_line_num": 379,
                "comment_line_num": 0,
                "blank_line_num": 153,
                "total_line_num": 532,
                "add_code_line_num": 379,
                "add_comment_line_num": 0,
                "add_blank_line_num": 153,
                "add_total_line_num": 532,
                "mod_code_line_num": 0,
                "mod_comment_line_num": 0,
                "mod_blank_line_num": 0,
                "mod_total_line_num": 0,
                "del_code_line_num": 0,
                "del_comment_line_num": 0,
                "del_blank_line_num": 0,
                "del_total_line_num": 0,
                "project_id": 1815,
                "scan_id": 695,
                "is_latest": true,
                "name": "Markdown",
                "file_num": 7
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```
