# Quick start a code analysis 

## Create teams and projects

- **Create a new team**  
  Check here about [Team manage](../团队管理/团队管理.md)

  ![Create a new team](../../../images/create_team.png)

- **Create a new project for your team, or select an existing project then open the project**

  ![Create a new project](../../../images/create_team_group.png)

## Register your repository

- **Register your repository and go to code analysis**

  ![Register your repository](../../../images/create_repo.png)

  ![Go to code analysis](../../../images/start_scan_01.png)

## Start code analysis

### Initialization

  ![Start a analysis](../../../images/start_scan_02.png)

  ::: tip

  1. When starting code analysis for the first time, you can choose an existing analysis scheme template or create one.
  2. When you click "确认", the TCA will first create an analysis scheme for your repository, and create branch projects based on repository's branches and current analysis scheme for users to start code analysis.
  :::

### Run a code analysis

After initialization, you can use `Online analysis` or `Client analysis` to start a code analysis。

![Code analysis](../../../images/start_scan_06.png)

#### Online analysis

Online analysis means that the analysis task is registered to the execution queue in the server, and the task is assigned to the resident analysis node configured in the TCA. After the analysis is completed, the analysis result will upload to the TCA.

::: tip
Use online analysis, the TCA must have at least resident analysis node:
- If your TCA is deployed using the official out-of-the-box deployment script (Docker deployment, Docker-compose deployment, and source code deployment), an analysis node (client) has been started by default, which can be directly used for online analysis. Check here about [Node management](../后台管理/节点管理.md).


- You can also add more analysis nodes to perform parallel code analysis. To add new nodes, see [About node](../客户端/常驻节点分析.md)

**If there is no node avaliable, online analysis tasks cannot be assigned. Unassigned tasks will be automatically cancelled after timeout**。
:::

#### Client analysis

Client analysis is local analysis. You need to have a client locally and configure the client configuration file ` codelog.ini`, see [Start a local analysis](../客户端/本地分析.md) to configure your local client. After analysis, the report data will be uploaded.

## Analysis history

After the analysis, the data will be reported to the server. You can enter the analysis history page to check the analysis records and results.

![Analysis history](../../../images/start_scan_05.png)

## Analysis overview

After the analysis, you can check a branch overview and [Defects list](../代码检查/分析结果查看.md) by entering `Branch overview` 等。

![Branch overview](../../../images/start_scan_04.png)
