# 客户端本地分析

## 使用场景

- 希望在本地随时分析。

- 接入持续集成系统实现自动化分析。

## 前置步骤
**1. 客户端运行环境机器配置推荐**

|   操作系统 | 推荐配置                                       |
| --------: | :------------------------------------------- |
|     Linux | 8核16G内存，硬盘空间256G（可用空间不低于100G）     |
|       Mac | 8核16G内存，硬盘空间256G（可用空间不低于100G）     |
|   Windows | 8核16G内存，硬盘空间256G（可用空间不低于100G）     |

以上为推荐配置，实际情况需要考虑扫描对象代码库的大小，按实际情况增加磁盘空间。

**2. 本地需具备客户端**

下载[开源版源码](https://github.com/Tencent/CodeAnalysis)。
或从[开源版release](https://github.com/Tencent/CodeAnalysis/releases)下载客户端以运行客户端二进制；


**3. 安装Python环境和第三方库（仅客户端源码启动分析需要）**
- 预装Python3.7、pip，支持 `python3` 和 `pip3` 命令
- 安装依赖：`pip3 install -r CodeAnalysis/client/requirements/app_reqs.pip`

**4. 安装第三方工具（docker下启动分析可跳过）**
- 在命令行(windows环境下可以启动`git bash`)中执行以下命令：
```bash
bash ./scripts/base/install_bin.sh
```
- 进入到`client/requirements`目录
- 在命令行中执行安装脚本`install.sh`(linux/mac环境)或`install.bat`(windows环境)


## 分析配置

### 配置客户端 `config.ini` 文件
- 将 `<Server IP地址>` 替换成实际的TCA平台IP（可包含端口号）

### 配置客户端 `codedog.ini` 文件

`codedog.ini`获取方法：
- 方法一： 打开TCA源码`CodeAnalysis/client/codedog.ini`，填写配置信息
- 方法二： 从[开源版release](https://github.com/Tencent/CodeAnalysis/releases)下载客户端包，解压后打开codedog.ini，填写配置信息。
- 方法三： 在TCA平台平台上配置好对应信息后，下载配置文件到本地使用。

  ![下载配置文件](../../../images/start_scan_03.png)

`codedog.ini`中以下字段为必填项：

|   字段名 | 填写说明                                       |
| :-------- | :------------------------------------------- |
|`token` | 从TCA平台页面获取，前往[个人中心]-[个人令牌]-复制Token |
|`org_sid`(团队编号) | 从TCA平台项目概览页面URL中获取，项目概览URL格式：`http://{域名}/t/{org_sid}/p/{team_name}/profile` |
|`team_name`(项目名称) | 同上 |
|`source_dir` | 本地代码目录路径 |

其他字段按需填写。

## 启动代码分析

启动客户端分析有三种方式可选：[客户端源码下启动分析](#客户端源码下启动分析)、[客户端二进制启动分析](#客户端二进制启动分析)、[docker下启动分析](#docker下启动分析)
### 客户端源码下启动分析

- 进入到客户端`client`目录下

- 执行命令：
  客户端源码：`python3 codepuppy.py localscan` 

### 客户端二进制启动分析
- 进入到客户端`client`目录下

- 执行命令：
  客户端源码：`./codepuppy localscan` 

### docker下启动分析

#### 1. 构建docker镜像
在client目录下，执行以下命令：`docker build -t tca-client .`  
**(需已安装Docker)**

#### 2. 执行Docker容器
::: warning
注意：因为以下步骤会将代码目录挂载到容器中，需要先将codedog.ini里面的source_dir修改为/workspace/src，其他参数保持不变。
:::

执行Docker容器有以下两种方式：
#### 直接使用docker运行

  在`client`目录下，执行以下命令：(注意：按照实际情况填写`SOURCE_DIR`环境变量值)

```bash
export SOURCE_DIR=需要扫描的代码目录绝对路径
docker run -it --rm  -v $PWD:/workspace/client -v $SOURCE_DIR:/workspace/src  --name tca-client tca-client
```

#### 使用docker内bash终端运行

  通过以下方式，进入容器内的bash终端后，通过命令行启动client代码：  
  在`client`目录下，执行以下命令：(注意：按照实际情况填写`SOURCE_DIR`环境变量值)

```bash
export SOURCE_DIR=需要扫描的代码目录绝对路径
docker run -it --rm  -v $PWD:/workspace/client -v $SOURCE_DIR:/workspace/src  --name tca-client tca-client bash
# 进入容器内终端，通过命令行执行扫描
python3 codepuppy.py localscan
```
