# 快速扫描模式

## 使用场景

- 对本地代码目录下的临时代码（未关联scm仓库或未提交到scm仓库的本地代码）进行扫描，对某个目录或某些文件进行快速扫描，产出本地扫描结果。

- 该模式不与scm代码仓库关联，只对给定的目录或文件进行扫描，不依据提交版本号做增量分析，也不定位问题责任人。

## 使用步骤

### 1. 在页面上创建分析方案模板

- 由于该模式不与scm代码仓库绑定，因此不能直接使用分析方案（分析方案上归属于某个代码仓库下的），需要使用分析方案模板的配置来扫描。

- 目前快速扫描模式只支持代码检查，暂不支持代码度量，请勿开启代码度量配置项（无法展示结果）。

- 配置好方案模板后，从页面URL中获取到分析方案模板ID，分析方案模板页面URL格式：`http://{域名}/t/{org_sid}/p/{team_name}/template/{分析方案模板ID}`，`template`后面的数字即分析方案模板ID。

### 2. 初始化扫描需要的工具

- 进入到客户端`client`目录下，使用`quickinit`命令拉取指定分析方案模板所需要的分析工具：

```commandline
python3 codepuppy.py quickinit -t TOKEN --scheme-template-id SCHEME_TEMPLATE_ID --org-sid ORG_SID
```

- 参数说明：
  - `TOKEN`: 必选，从TCA平台页面获取，前往`[个人中心]`-`[个人令牌]`-复制Token
  - `SCHEME_TEMPLATE_ID`: 必选，分析方案模板ID，从步骤1中获取
  - `ORG_SID`: 必选，团队编号，从TCA平台团队概览URL中获取，项目概览URL格式：`http://{域名}/t/{org_sid}/profile`

### 3. 执行快速扫描

- 进入到客户端`client`目录下，执行命令：

```commandline
python3 codepuppy.py quickscan -t TOKEN --scheme-template-id SCHEME_TEMPLATE_ID --org-sid ORG_SID -s SOURCE_DIR --file FILE 
```

- 参数说明：
  - `SOURCE_DIR`: 必选，需要扫描的代码目录路径
  - `FILE`: 可选，指定文件扫描，格式为基于SOURCE_DIR的相对路径，多个文件用英文逗号(,)分隔。不指定文件，默认扫描整个代码目录。
  - 其他参数说明参考`quickinit`命令。

- 扫描完成后，结果会默认输出到客户端`client`目录下的`tca_quick_scan_report.json`文件中。结果只保存在本地，不会上报到服务端展示。