# 过滤配置

## 路径过滤

用于设定代码分析的范围，设定后，已经开启的代码检查、代码度量各项功能都会在指定的代码范围内生效。

目前支持**正则表达式**和**通配符**两种类型：

- **正则表达式**

  ```txt
  请填写相对路径(基于代码库根目录)，要求匹配到文件
  使用正则表达式格式，示例如下：
      代码根目录
      |-src
        |- test
            |- main_test.py
            |- input_test.py
        |- main.py
      |-test
        |- param_test.py
      匹配src/test目录：src/test/.*
      匹配根目录下的test目录：test/.*
      匹配所有_test.py后缀的文件：.*_test\\.py
  修改后，下次分析生效，需要启动一次全量分析处理历史存量问题。
  ```

  ```txt
  Include 表示只分析，如只分析 src/ 目录：src/.*
  Exclude 表示只屏蔽，如要屏蔽 src/lib/ 目录：src/lib/.*
  ```

- **通配符**

  ```txt
  请填写相对路径(基于代码库根目录)，要求匹配到文件
  使用Unix通配符格式，示例如下
      代码根目录
      |-src
        |- test
            |- main_test.py
            |- input_test.py
        |- main.py
      |-test
        |- param_test.py
      匹配src/test目录：src/test/*
      匹配根目录下的test目录：test/*
      匹配所有_test.py后缀的文件：*_test.py
  修改后，下次分析生效，需要启动一次全量分析处理历史存量问题。
  ```

  ```txt
  Include 表示只分析，如只分析 src/ 目录：src/*
  Exclude 表示只屏蔽，如要屏蔽 src/lib/ 目录：src/lib/*
  ```

如果几个分析方案希望共享相同的路径过滤方案，可以通过导入导出路径配置的方式进行处理。

::: tip
配置更改后，下次启动分析生效
:::

## 问题过滤

- **全局 Issue 忽略状态同步**

  仅对代码检查生效。开启后，在 Issue 页面进行全局忽略操作时，其他利用该方案分析的分析项目在发现相同 Issue 时，会同步忽略该 Issue。否则不受全局 Issue 忽略状态同步影响。
